/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.wiring;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class Splitter
extends Component {
    private final int[] bitFanIndices;
    public final int PORT_JOINED;

    public Splitter(String name, int bitSize, int fanouts) {
        this(name, Splitter.setupBitFanIndices(bitSize, fanouts));
    }

    public Splitter(String name, int[] bitFanIndices) {
        super(name, Splitter.setupPortBitsizes(bitFanIndices));
        this.bitFanIndices = bitFanIndices;
        this.PORT_JOINED = this.getNumPorts() - 1;
    }

    public int[] getBitFanIndices() {
        return this.bitFanIndices;
    }

    private static int[] setupBitFanIndices(int bitSize, int fanouts) {
        int numBitsPerFan = bitSize / fanouts;
        if (bitSize % fanouts != 0) {
            ++numBitsPerFan;
        }
        int[] bitFanIndices = new int[bitSize];
        for (int i = 0; i < bitSize; ++i) {
            bitFanIndices[i] = i / numBitsPerFan;
        }
        return bitFanIndices;
    }

    private static int[] setupPortBitsizes(int[] bitFanIndices) {
        int totalFans = 0;
        for (int bitFanIdx : bitFanIndices) {
            if (bitFanIdx <= totalFans) continue;
            totalFans = bitFanIdx;
        }
        int[] fanouts = new int[totalFans + 2];
        fanouts[totalFans + 1] = bitFanIndices.length;
        for (int bitFanIndex : bitFanIndices) {
            if (bitFanIndex < 0) continue;
            int n = bitFanIndex;
            fanouts[n] = fanouts[n] + 1;
        }
        return fanouts;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == this.PORT_JOINED) {
            if (this.bitFanIndices.length != value.getBitSize()) {
                throw new IllegalStateException(this + ": something went wrong somewhere. bitFanIndices = " + this.bitFanIndices.length + ", value.getBitSize() = " + value.getBitSize());
            }
            for (int i = 0; i < this.getNumPorts() - 1; ++i) {
                WireValue result = new WireValue(this.getPort(i).getLink().getBitSize());
                int currBit = 0;
                for (int j = 0; j < this.bitFanIndices.length; ++j) {
                    if (this.bitFanIndices[j] != i) continue;
                    result.setBit(currBit++, value.getBit(j));
                }
                state.pushValue(this.getPort(i), result);
            }
        } else {
            WireValue result = new WireValue(state.getLastPushed(this.getPort(this.PORT_JOINED)));
            int currBit = 0;
            for (int i = 0; i < this.bitFanIndices.length; ++i) {
                if (this.bitFanIndices[i] != portIndex) continue;
                result.setBit(i, value.getBit(currBit++));
            }
            if (currBit != value.getBitSize()) {
                throw new IllegalStateException(this + ": something went wrong somewhere. currBit = " + currBit + ", value.getBitSize() = " + value.getBitSize());
            }
            state.pushValue(this.getPort(this.PORT_JOINED), result);
        }
    }
}

