/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.wiring;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Utils;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Pin
extends Component {
    private Map<CircuitState, Set<PinChangeListener>> pinChangeListeners = new HashMap<CircuitState, Set<PinChangeListener>>();
    private int bitSize;
    private boolean isInput;
    public static final int PORT = 0;

    public Pin(String name, int bitSize, boolean isInput) {
        super(name, Utils.getFilledArray(1, bitSize));
        this.bitSize = bitSize;
        this.isInput = isInput;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public void addChangeListener(CircuitState state, PinChangeListener listener) {
        this.pinChangeListeners.computeIfAbsent(state, s -> new HashSet()).add(listener);
    }

    public void removeChangeListener(CircuitState state, PinChangeListener listener) {
        Set<PinChangeListener> listeners = this.pinChangeListeners.get(state);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void setValue(CircuitState state, WireValue value) {
        state.pushValue(this.getPort(0), value);
    }

    @Override
    public void init(CircuitState state, Object lastProperty) {
        if (this.getCircuit() != null && this.isInput && this.getCircuit().getTopLevelState() == state) {
            state.pushValue(this.getPort(0), WireValue.of(0L, this.getBitSize()));
        }
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        Set<PinChangeListener> listeners = this.pinChangeListeners.get(state);
        if (listeners != null) {
            for (PinChangeListener listener : listeners) {
                listener.valueChanged(this, state, value);
            }
        }
    }

    public static interface PinChangeListener {
        public void valueChanged(Pin var1, CircuitState var2, WireValue var3);
    }
}

