/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.wiring;

import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Simulator;
import com.ra4king.circuitsim.simulator.Utils;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Clock
extends Component {
    private static final Map<Simulator, ClockInfo> simulatorClocks = new ConcurrentHashMap<Simulator, ClockInfo>();
    public static final int PORT = 0;

    public Clock(String name) {
        super(name, Utils.getFilledArray(1, 1));
    }

    @Override
    public void setCircuit(Circuit circuit) {
        ClockInfo clock;
        Circuit old = this.getCircuit();
        super.setCircuit(circuit);
        if (old != null && (clock = simulatorClocks.get(old.getSimulator())) != null) {
            clock.clocks.remove(this);
        }
        if (circuit != null) {
            clock = Clock.get(circuit.getSimulator());
            clock.clocks.put(this, this);
        }
    }

    @Override
    public void init(CircuitState circuitState, Object lastProperty) {
        ClockInfo clock = Clock.get(this.getCircuit().getSimulator());
        circuitState.pushValue(this.getPort(0), WireValue.of(clock.clock ? 1L : 0L, 1));
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
    }

    private static ClockInfo get(Simulator simulator) {
        return simulatorClocks.computeIfAbsent(simulator, s -> new ClockInfo());
    }

    public static void tick(Simulator simulator) {
        ClockInfo clock = Clock.get(simulator);
        clock.tick();
    }

    public static boolean getTickState(Simulator simulator) {
        ClockInfo clock = Clock.get(simulator);
        return clock.clock;
    }

    public static int getLastTickCount(Simulator simulator) {
        ClockInfo clock = Clock.get(simulator);
        return clock.lastTickCount;
    }

    public static void reset(Simulator simulator) {
        ClockInfo clock = Clock.get(simulator);
        clock.reset();
    }

    public static void startClock(Simulator simulator, int hertz) {
        ClockInfo clock = Clock.get(simulator);
        clock.startClock(hertz);
    }

    public static boolean isRunning(Simulator simulator) {
        ClockInfo clock = Clock.get(simulator);
        return clock.currentClock != null;
    }

    public static void stopClock(Simulator simulator) {
        ClockInfo clock = Clock.get(simulator);
        clock.stopClock();
    }

    public static void addChangeListener(Simulator simulator, ClockChangeListener listener) {
        ClockInfo clock = Clock.get(simulator);
        clock.clockChangeListeners.put(listener, listener);
    }

    public static void removeChangeListener(Simulator simulator, ClockChangeListener listener) {
        ClockInfo clock = Clock.get(simulator);
        clock.clockChangeListeners.remove(listener);
    }

    public static interface ClockChangeListener {
        public void valueChanged(WireValue var1);
    }

    private static class ClockInfo {
        private Map<Clock, Object> clocks = new ConcurrentHashMap<Clock, Object>();
        private Map<ClockChangeListener, Object> clockChangeListeners = new ConcurrentHashMap<ClockChangeListener, Object>();
        private Thread currentClock;
        private boolean clock;
        private long lastTickTime;
        private long lastPrintTime;
        private int tickCount;
        private volatile int lastTickCount;

        private ClockInfo() {
        }

        void reset() {
            this.stopClock();
            if (this.clock) {
                this.tick();
            }
        }

        void tick() {
            this.clock = !this.clock;
            WireValue clockValue = WireValue.of(this.clock ? 1L : 0L, 1);
            this.clocks.forEach((clock, o) -> {
                if (clock.getCircuit() != null) {
                    clock.getCircuit().forEachState(state -> state.pushValue(clock.getPort(0), clockValue));
                }
            });
            this.clockChangeListeners.forEach((listener, o) -> listener.valueChanged(clockValue));
        }

        void startClock(int hertz) {
            this.lastTickTime = this.lastPrintTime = System.nanoTime();
            this.tickCount = 0;
            this.lastTickCount = 0;
            long nanosPerTick = (long)(1.0E9 / (double)(2 * hertz));
            this.stopClock();
            Thread clockThread = new Thread(() -> {
                Thread thread = this.currentClock;
                while (thread != null && !thread.isInterrupted()) {
                    long now = System.nanoTime();
                    if ((double)(now - this.lastPrintTime) >= 1.0E9) {
                        this.lastTickCount = this.tickCount;
                        this.tickCount = 0;
                        this.lastPrintTime = now;
                        this.lastTickTime = now;
                    }
                    this.tick();
                    ++this.tickCount;
                    this.lastTickTime += nanosPerTick;
                    long diff = this.lastTickTime - System.nanoTime();
                    if (!((double)diff >= 1000000.0) && this.tickCount >> 1 < hertz) continue;
                    try {
                        Thread.sleep(Math.max(1L, (long)((double)diff / 1000000.0)));
                    }
                    catch (InterruptedException exc) {
                        break;
                    }
                }
            });
            clockThread.setName("Clock thread");
            clockThread.setDaemon(true);
            this.currentClock = clockThread;
            clockThread.start();
        }

        void stopClock() {
            if (this.currentClock != null) {
                Thread clockThread = this.currentClock;
                this.currentClock.interrupt();
                this.currentClock = null;
                this.lastTickCount = 0;
                while (clockThread.isAlive()) {
                    Thread.yield();
                }
            }
        }
    }
}

