/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.plexers;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.Arrays;

public class PriorityEncoder
extends Component {
    private final int numSelectBits;
    private boolean isEnabled;

    public PriorityEncoder(String name, int numSelectBits) {
        super(name, PriorityEncoder.createBitSizeArray(numSelectBits));
        this.numSelectBits = numSelectBits;
        this.isEnabled = false;
    }

    private static int[] createBitSizeArray(int numSelectBits) {
        int[] portBits = new int[(1 << numSelectBits) + 4];
        Arrays.fill(portBits, 0, (1 << numSelectBits) + 3, 1);
        portBits[portBits.length - 1] = numSelectBits;
        return portBits;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        Port out = this.getOutputPort();
        if (portIndex == 1 << this.numSelectBits) {
            boolean bl = this.isEnabled = value.getBit(0) == WireValue.State.ONE;
        }
        if (!this.isEnabled) {
            state.pushValue(this.getEnabledOutPort(), new WireValue(1, WireValue.State.ZERO));
            state.pushValue(out, new WireValue(out.getLink().getBitSize(), WireValue.State.X));
            state.pushValue(this.getGroupSignalPort(), new WireValue(1, WireValue.State.ZERO));
            return;
        }
        int highest = -1;
        int ports = 1 << this.numSelectBits;
        for (int i = 0; i < ports; ++i) {
            if (state.getLastReceived(this.getPort(i)).getBit(0) != WireValue.State.ONE && (i != portIndex || value.getBit(0) != WireValue.State.ONE)) continue;
            highest = i;
        }
        if (highest == -1) {
            state.pushValue(this.getEnabledOutPort(), new WireValue(1, WireValue.State.ONE));
            state.pushValue(out, new WireValue(out.getLink().getBitSize(), WireValue.State.X));
            state.pushValue(this.getGroupSignalPort(), new WireValue(1, WireValue.State.ZERO));
        } else {
            state.pushValue(this.getEnabledOutPort(), new WireValue(1, WireValue.State.ZERO));
            state.pushValue(this.getGroupSignalPort(), new WireValue(1, WireValue.State.ONE));
            state.pushValue(this.getOutputPort(), WireValue.of(highest, out.getLink().getBitSize()));
        }
    }

    public int getNumSelectBits() {
        return this.numSelectBits;
    }

    public Port getEnabledInPort() {
        return this.getPort(1 << this.numSelectBits);
    }

    public Port getEnabledOutPort() {
        return this.getPort((1 << this.numSelectBits) + 1);
    }

    public Port getGroupSignalPort() {
        return this.getPort((1 << this.numSelectBits) + 2);
    }

    public Port getOutputPort() {
        return this.getPort((1 << this.numSelectBits) + 3);
    }
}

