/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.plexers;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.Arrays;

public class Multiplexer
extends Component {
    private final int bitSize;
    private final int numSelectBits;
    private final int numInputs;

    public Multiplexer(String name, int bitSize, int numSelectBits) {
        super(name, Multiplexer.createBitSizeArray(bitSize, numSelectBits));
        this.bitSize = bitSize;
        this.numSelectBits = numSelectBits;
        this.numInputs = 1 << numSelectBits;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public int getNumSelectBits() {
        return this.numSelectBits;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public Port getInputPort(int index) {
        return this.getPort(index);
    }

    public Port getSelectorPort() {
        return this.getPort(this.getNumPorts() - 2);
    }

    public Port getOutPort() {
        return this.getPort(this.getNumPorts() - 1);
    }

    private static int[] createBitSizeArray(int bitSize, int numSelectBits) {
        int[] bitSizes = new int[(1 << numSelectBits) + 2];
        Arrays.fill(bitSizes, 0, 1 << numSelectBits, bitSize);
        bitSizes[bitSizes.length - 2] = numSelectBits;
        bitSizes[bitSizes.length - 1] = bitSize;
        return bitSizes;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        Port selectorPort = this.getSelectorPort();
        WireValue currentSelect = state.getLastReceived(selectorPort);
        if (this.getPort(portIndex) == selectorPort) {
            if (!value.isValidValue() || !state.getLastReceived(this.getPort(value.getValue())).isValidValue()) {
                state.pushValue(this.getOutPort(), new WireValue(this.getBitSize()));
            } else {
                state.pushValue(this.getOutPort(), state.getLastReceived(this.getPort(value.getValue())));
            }
        } else if (portIndex < this.getNumPorts() - 2) {
            if (currentSelect.isValidValue()) {
                if (currentSelect.getValue() == portIndex) {
                    state.pushValue(this.getOutPort(), value);
                }
            } else {
                state.pushValue(this.getOutPort(), new WireValue(this.getBitSize()));
            }
        }
    }
}

