/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.plexers;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.Arrays;

public class Demultiplexer
extends Component {
    private final int bitSize;
    private final int numSelectBits;
    private final int numOutputs;

    public Demultiplexer(String name, int bitSize, int numSelectBits) {
        super(name, Demultiplexer.createBitSizeArray(bitSize, numSelectBits));
        this.bitSize = bitSize;
        this.numSelectBits = numSelectBits;
        this.numOutputs = 1 << numSelectBits;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public int getNumSelectBits() {
        return this.numSelectBits;
    }

    public int getNumOutputs() {
        return this.numOutputs;
    }

    public Port getOutputPort(int index) {
        return this.getPort(index);
    }

    public Port getSelectorPort() {
        return this.getPort(this.getNumPorts() - 2);
    }

    public Port getInputPort() {
        return this.getPort(this.getNumPorts() - 1);
    }

    private static int[] createBitSizeArray(int bitSize, int numSelectBits) {
        int[] bitSizes = new int[(1 << numSelectBits) + 2];
        Arrays.fill(bitSizes, 0, 1 << numSelectBits, bitSize);
        bitSizes[bitSizes.length - 2] = numSelectBits;
        bitSizes[bitSizes.length - 1] = bitSize;
        return bitSizes;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        Port selectorPort = this.getSelectorPort();
        if (this.getPort(portIndex) == selectorPort) {
            if (!value.isValidValue()) {
                for (int i = 0; i < this.numOutputs; ++i) {
                    state.pushValue(this.getOutputPort(i), new WireValue(this.getBitSize()));
                }
            } else {
                int selectedPort = value.getValue();
                for (int i = 0; i < this.numOutputs; ++i) {
                    if (i == selectedPort) {
                        state.pushValue(this.getOutputPort(i), state.getLastReceived(this.getInputPort()));
                        continue;
                    }
                    state.pushValue(this.getOutputPort(i), WireValue.of(0L, this.getBitSize()));
                }
            }
        } else if (this.getPort(portIndex) == this.getInputPort() && state.getLastReceived(selectorPort).isValidValue()) {
            int selectedPort = state.getLastReceived(selectorPort).getValue();
            state.pushValue(this.getOutputPort(selectedPort), value);
        }
    }
}

