/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.plexers;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.Arrays;

public class Decoder
extends Component {
    private final int numSelectBits;
    private final int numOutputs;

    public Decoder(String name, int numSelectBits) {
        super(name, Decoder.createBitSizeArray(numSelectBits));
        this.numSelectBits = numSelectBits;
        this.numOutputs = 1 << numSelectBits;
    }

    public int getNumSelectBits() {
        return this.numSelectBits;
    }

    public int getNumOutputs() {
        return this.numOutputs;
    }

    public Port getOutputPort(int index) {
        return this.getPort(index);
    }

    public Port getSelectorPort() {
        return this.getPort(this.getNumPorts() - 1);
    }

    private static int[] createBitSizeArray(int numSelectBits) {
        int[] bitSizes = new int[(1 << numSelectBits) + 1];
        Arrays.fill(bitSizes, 0, 1 << numSelectBits, 1);
        bitSizes[bitSizes.length - 1] = numSelectBits;
        return bitSizes;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        block5: {
            Port selectorPort = this.getSelectorPort();
            if (this.getPort(portIndex) != selectorPort) break block5;
            if (!value.isValidValue()) {
                for (int i = 0; i < this.numOutputs; ++i) {
                    state.pushValue(this.getOutputPort(i), new WireValue(1));
                }
            } else {
                int selectedPort = value.getValue();
                for (int i = 0; i < this.numOutputs; ++i) {
                    if (i == selectedPort) {
                        state.pushValue(this.getOutputPort(i), WireValue.of(1L, 1));
                        continue;
                    }
                    state.pushValue(this.getOutputPort(i), WireValue.of(0L, 1));
                }
            }
        }
    }
}

