/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.memory;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Utils;
import com.ra4king.circuitsim.simulator.WireValue;

public class SRFlipFlop
extends Component {
    public static final int PORT_S = 0;
    public static final int PORT_R = 1;
    public static final int PORT_CLOCK = 2;
    public static final int PORT_ENABLE = 3;
    public static final int PORT_PRESET = 4;
    public static final int PORT_CLEAR = 5;
    public static final int PORT_Q = 6;
    public static final int PORT_QN = 7;

    public SRFlipFlop(String name) {
        super(name, Utils.getFilledArray(8, 1));
    }

    private void pushValue(CircuitState state, WireValue.State bit) {
        state.putComponentProperty(this, (Object)bit);
        state.pushValue(this.getPort(6), new WireValue(1, bit));
        state.pushValue(this.getPort(7), new WireValue(1, bit.negate()));
    }

    @Override
    public void init(CircuitState state, Object lastProperty) {
        this.pushValue(state, lastProperty == null ? WireValue.State.ZERO : (WireValue.State)((Object)lastProperty));
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 6 || portIndex == 7) {
            return;
        }
        WireValue.State clear = state.getLastReceived(this.getPort(5)).getBit(0);
        WireValue.State preset = state.getLastReceived(this.getPort(4)).getBit(0);
        WireValue.State enable = state.getLastReceived(this.getPort(3)).getBit(0);
        if (clear == WireValue.State.ONE) {
            this.pushValue(state, WireValue.State.ZERO);
        } else if (preset == WireValue.State.ONE) {
            this.pushValue(state, WireValue.State.ONE);
        } else if (enable != WireValue.State.ZERO && portIndex == 2 && value.getBit(0) == WireValue.State.ONE) {
            WireValue.State s = state.getLastReceived(this.getPort(0)).getBit(0);
            WireValue.State r = state.getLastReceived(this.getPort(1)).getBit(0);
            if (s == WireValue.State.ONE && r == WireValue.State.ZERO) {
                this.pushValue(state, WireValue.State.ONE);
            } else if (r == WireValue.State.ONE && s == WireValue.State.ZERO) {
                this.pushValue(state, WireValue.State.ZERO);
            }
        }
    }
}

