/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.memory;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class Register
extends Component {
    public static final int PORT_IN = 0;
    public static final int PORT_ENABLE = 1;
    public static final int PORT_CLK = 2;
    public static final int PORT_ZERO = 3;
    public static final int PORT_OUT = 4;
    private final int bitSize;

    public Register(String name, int bitSize) {
        super(name, new int[]{bitSize, 1, 1, 1, bitSize});
        this.bitSize = bitSize;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public void init(CircuitState circuitState, Object lastProperty) {
        WireValue value = lastProperty == null ? WireValue.of(0L, this.bitSize) : new WireValue((WireValue)lastProperty, this.bitSize);
        circuitState.pushValue(this.getPort(4), value);
        circuitState.putComponentProperty(this, value);
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 4) {
            return;
        }
        if (state.getLastReceived(this.getPort(3)).getBit(0) == WireValue.State.ONE) {
            WireValue pushValue = WireValue.of(0L, this.bitSize);
            state.pushValue(this.getPort(4), pushValue);
            state.putComponentProperty(this, pushValue);
        } else if (state.getLastReceived(this.getPort(1)).getBit(0) != WireValue.State.ZERO && portIndex == 2 && value.getBit(0) == WireValue.State.ONE) {
            WireValue pushValue = state.getLastReceived(this.getPort(0));
            state.pushValue(this.getPort(4), pushValue);
            state.putComponentProperty(this, pushValue);
        }
    }
}

