/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.memory;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.Arrays;

public class ROM
extends Component {
    public static final int PORT_ADDRESS = 0;
    public static final int PORT_ENABLE = 1;
    public static final int PORT_DATA = 2;
    private final int addressBits;
    private final int dataBits;
    private final int[] memory;

    public ROM(String name, int bitSize, int addressBits, int[] memory) {
        super(name, new int[]{addressBits, 1, bitSize});
        if (addressBits > 16 || addressBits <= 0) {
            throw new IllegalArgumentException("Address bits cannot be more than 16 bits.");
        }
        this.addressBits = addressBits;
        this.dataBits = bitSize;
        this.memory = Arrays.copyOf(memory, 1 << addressBits);
    }

    public int getAddressBits() {
        return this.addressBits;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int[] getMemory() {
        return this.memory;
    }

    public WireValue load(int address) {
        if (address < 0 || address >= this.memory.length) {
            return null;
        }
        return WireValue.of(this.memory[address], this.dataBits);
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        boolean enabled = state.getLastReceived(this.getPort(1)).getBit(0) != WireValue.State.ZERO;
        WireValue address = state.getLastReceived(this.getPort(0));
        if (enabled && address.isValidValue()) {
            state.pushValue(this.getPort(2), this.load(address.getValue()));
        } else {
            state.pushValue(this.getPort(2), new WireValue(this.dataBits));
        }
    }
}

