/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.memory;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class RAM
extends Component {
    public static final int PORT_ADDRESS = 0;
    public static final int PORT_ENABLE = 1;
    public static final int PORT_CLK = 2;
    public static final int PORT_LOAD = 3;
    public static final int PORT_CLEAR = 4;
    public static final int PORT_DATA = 5;
    private final int addressBits;
    private final int dataBits;
    private List<BiConsumer<Integer, Integer>> listeners = new ArrayList<BiConsumer<Integer, Integer>>();

    public RAM(String name, int bitSize, int addressBits) {
        super(name, new int[]{addressBits, 1, 1, 1, 1, bitSize});
        if (addressBits > 16 || addressBits <= 0) {
            throw new IllegalArgumentException("Address bits cannot be more than 16 bits.");
        }
        this.addressBits = addressBits;
        this.dataBits = bitSize;
    }

    public int getAddressBits() {
        return this.addressBits;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public void addMemoryListener(BiConsumer<Integer, Integer> listener) {
        this.listeners.add(listener);
    }

    public void removeMemoryListener(BiConsumer<Integer, Integer> listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(int address, int data) {
        this.listeners.forEach(listener -> listener.accept(address, data));
    }

    public void store(CircuitState state, int address, int data) {
        this.getMemoryContents((CircuitState)state)[address] = data;
        boolean enabled = state.getLastReceived(this.getPort(1)).getBit(0) != WireValue.State.ZERO;
        boolean load = state.getLastReceived(this.getPort(3)).getBit(0) != WireValue.State.ZERO;
        WireValue addressValue = state.getLastReceived(this.getPort(0));
        if (enabled && load && addressValue.isValidValue() && addressValue.getValue() == address) {
            state.pushValue(this.getPort(5), WireValue.of(data, this.getDataBits()));
        }
        this.notifyListeners(address, data);
    }

    public int load(CircuitState circuitState, int address) {
        return this.getMemoryContents(circuitState)[address];
    }

    public int[] getMemoryContents(CircuitState circuitState) {
        return (int[])circuitState.getComponentProperty(this);
    }

    @Override
    public void init(CircuitState circuitState, Object lastProperty) {
        circuitState.putComponentProperty(this, new int[1 << this.addressBits]);
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        int[] memory = this.getMemoryContents(state);
        boolean enabled = state.getLastReceived(this.getPort(1)).getBit(0) != WireValue.State.ZERO;
        boolean load = state.getLastReceived(this.getPort(3)).getBit(0) != WireValue.State.ZERO;
        boolean clear = state.getLastReceived(this.getPort(4)).getBit(0) == WireValue.State.ONE;
        WireValue address = state.getLastReceived(this.getPort(0));
        switch (portIndex) {
            case 1: 
            case 3: {
                if (!enabled || !load) {
                    state.pushValue(this.getPort(5), new WireValue(this.dataBits));
                }
            }
            case 0: {
                if (!enabled || !load || !address.isValidValue()) break;
                state.pushValue(this.getPort(5), WireValue.of(this.load(state, address.getValue()), this.getDataBits()));
                break;
            }
            case 2: {
                if (load || value.getBit(0) != WireValue.State.ONE || !address.isValidValue()) break;
                WireValue lastReceived = state.getLastReceived(this.getPort(5));
                if (lastReceived.isValidValue()) {
                    this.store(state, address.getValue(), lastReceived.getValue());
                    break;
                }
                this.store(state, address.getValue(), WireValue.of(-1L, this.getDataBits()).getValue());
                break;
            }
            case 4: {
                if (!clear) break;
                for (int i = 0; i < memory.length; ++i) {
                    this.store(state, i, 0);
                }
                break;
            }
        }
    }
}

