/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.memory;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Utils;
import com.ra4king.circuitsim.simulator.WireValue;

public class DFlipFlop
extends Component {
    public static final int PORT_D = 0;
    public static final int PORT_CLOCK = 1;
    public static final int PORT_ENABLE = 2;
    public static final int PORT_PRESET = 3;
    public static final int PORT_CLEAR = 4;
    public static final int PORT_Q = 5;
    public static final int PORT_QN = 6;

    public DFlipFlop(String name) {
        super(name, Utils.getFilledArray(7, 1));
    }

    private void pushValue(CircuitState state, WireValue.State bit) {
        state.putComponentProperty(this, (Object)bit);
        state.pushValue(this.getPort(5), new WireValue(1, bit));
        state.pushValue(this.getPort(6), new WireValue(1, bit.negate()));
    }

    @Override
    public void init(CircuitState state, Object lastProperty) {
        this.pushValue(state, lastProperty == null ? WireValue.State.ZERO : (WireValue.State)((Object)lastProperty));
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        WireValue.State d;
        if (portIndex == 5 || portIndex == 6) {
            return;
        }
        WireValue.State clear = state.getLastReceived(this.getPort(4)).getBit(0);
        WireValue.State preset = state.getLastReceived(this.getPort(3)).getBit(0);
        WireValue.State enable = state.getLastReceived(this.getPort(2)).getBit(0);
        if (clear == WireValue.State.ONE) {
            this.pushValue(state, WireValue.State.ZERO);
        } else if (preset == WireValue.State.ONE) {
            this.pushValue(state, WireValue.State.ONE);
        } else if (enable != WireValue.State.ZERO && portIndex == 1 && value.getBit(0) == WireValue.State.ONE && (d = state.getLastReceived(this.getPort(0)).getBit(0)) != WireValue.State.X) {
            this.pushValue(state, d);
        }
    }
}

