/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.gates;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.Utils;
import com.ra4king.circuitsim.simulator.WireValue;

public abstract class Gate
extends Component {
    private final int bitSize;
    private final int numInputs;
    private final boolean[] negateInputs;
    private final boolean negateOutput;

    public Gate(String name, int bitSize, int numInputs) {
        this(name, bitSize, numInputs, false);
    }

    public Gate(String name, int bitSize, int numInputs, boolean negateOutput) {
        this(name, bitSize, numInputs, new boolean[numInputs], negateOutput);
    }

    public Gate(String name, int bitSize, int numInputs, boolean[] negateInputs, boolean negateOutput) {
        super(name, Utils.getFilledArray(numInputs + 1, bitSize));
        if (negateInputs.length != numInputs) {
            throw new IllegalArgumentException("negateInputs array must be the same length as numInputs");
        }
        this.bitSize = bitSize;
        this.numInputs = numInputs;
        this.negateInputs = negateInputs;
        this.negateOutput = negateOutput;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public Port getOutPort() {
        return this.getPort(this.numInputs);
    }

    public boolean[] getNegateInputs() {
        return this.negateInputs;
    }

    public boolean getNegateOutput() {
        return this.negateOutput;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == this.numInputs) {
            return;
        }
        WireValue result = new WireValue(value.getBitSize());
        for (int bit = 0; bit < result.getBitSize(); ++bit) {
            WireValue.State portBit = state.getLastReceived(this.getPort(0)).getBit(bit);
            if (this.negateInputs[0]) {
                portBit = portBit.negate();
            }
            result.setBit(bit, portBit);
            boolean isX = result.getBit(bit) == WireValue.State.X;
            for (int port = 1; port < this.numInputs; ++port) {
                portBit = state.getLastReceived(this.getPort(port)).getBit(bit);
                if (this.negateInputs[port]) {
                    portBit = portBit.negate();
                }
                isX &= portBit == WireValue.State.X;
                result.setBit(bit, this.operate(result.getBit(bit), portBit));
            }
            if (isX) {
                result.setBit(bit, WireValue.State.X);
                continue;
            }
            if (!this.negateOutput) continue;
            result.setBit(bit, result.getBit(bit) == WireValue.State.ONE ? WireValue.State.ZERO : WireValue.State.ONE);
        }
        state.pushValue(this.getOutPort(), result);
    }

    protected WireValue.State operate(WireValue.State acc, WireValue.State bit) {
        return null;
    }
}

