/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class Subtractor
extends Component {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    public static final int PORT_CARRY_IN = 2;
    public static final int PORT_OUT = 3;
    public static final int PORT_CARRY_OUT = 4;
    private final int bitSize;

    public Subtractor(String name, int bitSize) {
        super(name, new int[]{bitSize, bitSize, 1, bitSize, 1});
        this.bitSize = bitSize;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 3 || portIndex == 4) {
            return;
        }
        if (state.getLastReceived(this.getPort(0)).isValidValue() && state.getLastReceived(this.getPort(1)).isValidValue()) {
            int a = state.getLastReceived(this.getPort(0)).getValue();
            int b = state.getLastReceived(this.getPort(1)).getValue();
            WireValue carry = state.getLastReceived(this.getPort(2));
            int c = carry.getBit(0) == WireValue.State.ONE ? 1 : 0;
            state.pushValue(this.getPort(3), WireValue.of(a - b - c, this.bitSize));
            state.pushValue(this.getPort(4), WireValue.of(a - b - c < 0 ? 1L : 0L, 1));
        } else {
            state.pushValue(this.getPort(3), new WireValue(this.bitSize));
            state.pushValue(this.getPort(4), new WireValue(1));
        }
    }
}

