/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class Shifter
extends Component {
    public static final int PORT_IN = 0;
    public static final int PORT_SHIFT = 1;
    public static final int PORT_OUT = 2;
    private final int bitSize;
    private final ShiftType shiftType;

    public Shifter(String name, int bitSize, ShiftType shiftType) {
        super(name, new int[]{bitSize, Shifter.getShiftBits(bitSize), bitSize});
        this.bitSize = bitSize;
        this.shiftType = shiftType;
    }

    private static int getShiftBits(int bitSize) {
        return Math.max(1, (int)Math.ceil(Math.log(bitSize) / Math.log(2.0)));
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 2) {
            return;
        }
        WireValue valueIn = state.getLastReceived(this.getPort(0));
        WireValue shift = state.getLastReceived(this.getPort(1));
        WireValue result = new WireValue(this.bitSize);
        if (shift.isValidValue()) {
            result.setAllBits(WireValue.State.ZERO);
            int shiftValue = shift.getValue();
            boolean rotateRight = false;
            switch (this.shiftType) {
                case ROTATE_LEFT: {
                    int i;
                    for (i = shiftValue - 1; i >= 0; --i) {
                        result.setBit(i, valueIn.getBit(this.bitSize - (shiftValue - i)));
                    }
                }
                case LOGICAL_LEFT: {
                    int i;
                    for (i = this.bitSize - 1; i >= shiftValue; --i) {
                        result.setBit(i, valueIn.getBit(i - shiftValue));
                    }
                    break;
                }
                case ROTATE_RIGHT: {
                    int i;
                    rotateRight = true;
                    for (i = this.bitSize - shiftValue; i < this.bitSize; ++i) {
                        result.setBit(i, valueIn.getBit(i - (this.bitSize - shiftValue)));
                    }
                }
                case ARITHMETIC_RIGHT: {
                    int i;
                    if (!rotateRight) {
                        for (i = this.bitSize - shiftValue; i < this.bitSize; ++i) {
                            result.setBit(i, valueIn.getBit(this.bitSize - 1));
                        }
                    }
                }
                case LOGICAL_RIGHT: {
                    int i;
                    for (i = 0; i < this.bitSize - shiftValue; ++i) {
                        result.setBit(i, valueIn.getBit(i + shiftValue));
                    }
                    break;
                }
            }
        }
        state.pushValue(this.getPort(2), result);
    }

    public static enum ShiftType {
        LOGICAL_LEFT,
        LOGICAL_RIGHT,
        ARITHMETIC_RIGHT,
        ROTATE_LEFT,
        ROTATE_RIGHT;

    }
}

