/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class RandomGenerator
extends Component {
    public static final int PORT_CLK = 0;
    public static final int PORT_OUT = 1;
    private final int bitSize;

    public RandomGenerator(String name, int bitSize) {
        super(name, new int[]{1, bitSize});
        this.bitSize = bitSize;
    }

    @Override
    public void init(CircuitState circuitState, Object lastProperty) {
        circuitState.pushValue(this.getPort(1), this.getRandomValue());
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 0 && value.getBit(0) == WireValue.State.ONE) {
            state.pushValue(this.getPort(1), this.getRandomValue());
        }
    }

    private WireValue getRandomValue() {
        return WireValue.of((long)(Math.random() * (double)(1L << this.bitSize)), this.bitSize);
    }
}

