/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Utils;
import com.ra4king.circuitsim.simulator.WireValue;

public class Multiplier
extends Component {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    public static final int PORT_CARRY_IN = 2;
    public static final int PORT_OUT_LOWER = 3;
    public static final int PORT_OUT_UPPER = 4;
    private final int bitSize;

    public Multiplier(String name, int bitSize) {
        super(name, Utils.getFilledArray(5, bitSize));
        this.bitSize = bitSize;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 3 || portIndex == 4) {
            return;
        }
        if (state.getLastReceived(this.getPort(0)).isValidValue() && state.getLastReceived(this.getPort(1)).isValidValue()) {
            long a = (long)state.getLastReceived(this.getPort(0)).getValue() & 0xFFFFFFFFL;
            long b = (long)state.getLastReceived(this.getPort(1)).getValue() & 0xFFFFFFFFL;
            WireValue carry = state.getLastReceived(this.getPort(2));
            long c = carry.isValidValue() ? (long)carry.getValue() & 0xFFFFFFFFL : 0L;
            long product = a * b + c;
            int upper = (int)(product >>> this.bitSize);
            state.pushValue(this.getPort(3), WireValue.of((int)product, this.bitSize));
            state.pushValue(this.getPort(4), WireValue.of(upper, this.bitSize));
        } else {
            state.pushValue(this.getPort(3), new WireValue(this.bitSize));
            state.pushValue(this.getPort(4), new WireValue(this.bitSize));
        }
    }
}

