/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Utils;
import com.ra4king.circuitsim.simulator.WireValue;

public class Divider
extends Component {
    public static final int PORT_DIVIDEND = 0;
    public static final int PORT_DIVISOR = 1;
    public static final int PORT_QUOTIENT = 2;
    public static final int PORT_REMAINDER = 3;
    private final int bitSize;

    public Divider(String name, int bitSize) {
        super(name, Utils.getFilledArray(4, bitSize));
        this.bitSize = bitSize;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 2 || portIndex == 3) {
            return;
        }
        if (state.getLastReceived(this.getPort(0)).isValidValue() && state.getLastReceived(this.getPort(1)).isValidValue()) {
            int a = state.getLastReceived(this.getPort(0)).getValue();
            int b = state.getLastReceived(this.getPort(1)).getValue();
            int quotient = b == 0 ? a : a / b;
            int remainder = b == 0 ? 0 : a % b;
            state.pushValue(this.getPort(2), WireValue.of(quotient, this.bitSize));
            state.pushValue(this.getPort(3), WireValue.of(remainder, this.bitSize));
        } else {
            state.pushValue(this.getPort(2), new WireValue(this.bitSize));
            state.pushValue(this.getPort(3), new WireValue(this.bitSize));
        }
    }
}

