/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class Comparator
extends Component {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    public static final int PORT_LT = 2;
    public static final int PORT_EQ = 3;
    public static final int PORT_GT = 4;
    private final int bitSize;
    private final boolean useSignedCompare;

    public Comparator(String name, int bitSize, boolean useSignedCompare) {
        super(name, new int[]{bitSize, bitSize, 1, 1, 1});
        this.bitSize = bitSize;
        this.useSignedCompare = useSignedCompare;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        WireValue inputA = state.getLastReceived(this.getPort(0));
        WireValue inputB = state.getLastReceived(this.getPort(1));
        if (inputA.isValidValue() && inputB.isValidValue()) {
            long valueA = inputA.getValue();
            long valueB = inputB.getValue();
            if (this.useSignedCompare) {
                valueA |= (valueA & (long)(1 << this.bitSize - 1)) != 0L ? (long)(-1 << this.bitSize) : 0L;
                valueB |= (valueB & (long)(1 << this.bitSize - 1)) != 0L ? (long)(-1 << this.bitSize) : 0L;
            } else {
                valueA &= 0xFFFFFFFFL;
                valueB &= 0xFFFFFFFFL;
            }
            state.pushValue(this.getPort(2), new WireValue(1, valueA < valueB ? WireValue.State.ONE : WireValue.State.ZERO));
            state.pushValue(this.getPort(3), new WireValue(1, valueA == valueB ? WireValue.State.ONE : WireValue.State.ZERO));
            state.pushValue(this.getPort(4), new WireValue(1, valueA > valueB ? WireValue.State.ONE : WireValue.State.ZERO));
        } else {
            WireValue xValue = new WireValue(1, WireValue.State.X);
            state.pushValue(this.getPort(2), xValue);
            state.pushValue(this.getPort(3), xValue);
            state.pushValue(this.getPort(4), xValue);
        }
    }
}

