/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class BitExtender
extends Component {
    public static final int PORT_IN = 0;
    public static final int PORT_OUT = 1;
    private final int inputBitSize;
    private final int outputBitSize;
    private final ExtensionType extensionType;

    public BitExtender(String name, int inputBitSize, int outputBitSize, ExtensionType extensionType) {
        super(name, new int[]{inputBitSize, outputBitSize});
        this.inputBitSize = inputBitSize;
        this.outputBitSize = outputBitSize;
        this.extensionType = extensionType;
    }

    public int getInputBitSize() {
        return this.inputBitSize;
    }

    public int getOutputBitSize() {
        return this.outputBitSize;
    }

    public ExtensionType getExtensionType() {
        return this.extensionType;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 0) {
            WireValue extended = new WireValue(value, this.outputBitSize);
            if (this.outputBitSize > this.inputBitSize) {
                switch (this.extensionType) {
                    case SIGN: {
                        if (extended.getBit(this.inputBitSize - 1) != WireValue.State.ONE) break;
                    }
                    case ONE: {
                        for (int i = this.inputBitSize; i < this.outputBitSize; ++i) {
                            extended.setBit(i, WireValue.State.ONE);
                        }
                        break;
                    }
                }
            }
            state.pushValue(this.getPort(1), extended);
        }
    }

    public static enum ExtensionType {
        ZERO,
        ONE,
        SIGN;

    }
}

