/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components.arithmetic;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;

public class Adder
extends Component {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    public static final int PORT_CARRY_IN = 2;
    public static final int PORT_OUT = 3;
    public static final int PORT_CARRY_OUT = 4;
    private final int bitSize;

    public Adder(String name, int bitSize) {
        super(name, new int[]{bitSize, bitSize, 1, bitSize, 1});
        this.bitSize = bitSize;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        if (portIndex == 3 || portIndex == 4) {
            return;
        }
        if (state.getLastReceived(this.getPort(0)).isValidValue() && state.getLastReceived(this.getPort(1)).isValidValue()) {
            WireValue a = state.getLastReceived(this.getPort(0));
            WireValue b = state.getLastReceived(this.getPort(1));
            WireValue c = state.getLastReceived(this.getPort(2));
            WireValue sum = new WireValue(this.bitSize);
            WireValue.State carry = c.getBit(0) == WireValue.State.ONE ? WireValue.State.ONE : WireValue.State.ZERO;
            for (int i = 0; i < sum.getBitSize(); ++i) {
                WireValue.State bitA = a.getBit(i);
                WireValue.State bitB = b.getBit(i);
                sum.setBit(i, bitA == WireValue.State.ONE ^ bitB == WireValue.State.ONE ^ carry == WireValue.State.ONE ? WireValue.State.ONE : WireValue.State.ZERO);
                carry = bitA == WireValue.State.ONE && bitB == WireValue.State.ONE || bitA == WireValue.State.ONE && carry == WireValue.State.ONE || bitB == WireValue.State.ONE && carry == WireValue.State.ONE ? WireValue.State.ONE : WireValue.State.ZERO;
            }
            state.pushValue(this.getPort(3), sum);
            state.pushValue(this.getPort(4), new WireValue(1, carry));
        } else {
            state.pushValue(this.getPort(3), new WireValue(this.bitSize));
            state.pushValue(this.getPort(4), new WireValue(1));
        }
    }
}

