/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator.components;

import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.SimulationException;
import com.ra4king.circuitsim.simulator.WireValue;
import com.ra4king.circuitsim.simulator.components.wiring.Pin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Subcircuit
extends Component {
    private Circuit subcircuit;
    private List<Pin> pins;
    private Map<CircuitState, Map<Pin, Pin.PinChangeListener>> pinListeners;

    public Subcircuit(String name, Circuit subcircuit) {
        this(name, subcircuit, Subcircuit.getCircuitPins(subcircuit));
    }

    private Subcircuit(String name, Circuit subcircuit, List<Pin> pins) {
        super(name, Subcircuit.setupPortBits(pins));
        this.subcircuit = subcircuit;
        this.pins = pins;
        this.pinListeners = new HashMap<CircuitState, Map<Pin, Pin.PinChangeListener>>();
    }

    private static List<Pin> getCircuitPins(Circuit circuit) {
        return circuit.getComponents().stream().filter(component -> component instanceof Pin).map(component -> (Pin)component).collect(Collectors.toList());
    }

    private static int[] setupPortBits(List<Pin> pins) {
        int[] portBits = new int[pins.size()];
        for (int i = 0; i < portBits.length; ++i) {
            portBits[i] = pins.get(i).getBitSize();
        }
        return portBits;
    }

    public List<Pin> getPins() {
        return this.pins;
    }

    public Circuit getSubcircuit() {
        return this.subcircuit;
    }

    private void checkCircuitLoop(Circuit circuit) {
        if (circuit == this.getCircuit()) {
            throw new SimulationException("Subcircuit loop detected.");
        }
        for (Component component : circuit.getComponents()) {
            if (component == this || !(component instanceof Subcircuit)) continue;
            Subcircuit subcircuit = (Subcircuit)component;
            this.checkCircuitLoop(subcircuit.getSubcircuit());
        }
    }

    @Override
    public void setCircuit(Circuit circuit) {
        super.setCircuit(circuit);
        this.checkCircuitLoop(this.subcircuit);
    }

    @Override
    public void init(CircuitState circuitState, Object lastProperty) {
        CircuitState subcircuitState = new CircuitState(this.subcircuit);
        circuitState.putComponentProperty(this, subcircuitState);
        HashMap<Pin, Pin.PinChangeListener> listeners = new HashMap<Pin, Pin.PinChangeListener>();
        for (int i = 0; i < this.pins.size(); ++i) {
            Pin pin = this.pins.get(i);
            if (pin.isInput()) continue;
            Port port = this.getPort(i);
            Pin.PinChangeListener listener = (p, state, value) -> circuitState.pushValue(port, value);
            pin.addChangeListener(subcircuitState, listener);
            listeners.put(pin, listener);
        }
        this.pinListeners.put(subcircuitState, listeners);
        CircuitState oldState = (CircuitState)lastProperty;
        for (Component component : this.subcircuit.getComponents()) {
            component.init(subcircuitState, oldState == null ? null : oldState.getComponentProperty(component));
        }
        if (oldState != null) {
            this.getCircuit().removeState(oldState);
        }
    }

    public CircuitState getSubcircuitState(CircuitState parentState) {
        return (CircuitState)parentState.getComponentProperty(this);
    }

    @Override
    public void uninit(CircuitState circuitState) {
        CircuitState subcircuitState = (CircuitState)circuitState.getComponentProperty(this);
        this.subcircuit.getComponents().forEach(component -> component.uninit(subcircuitState));
        this.subcircuit.removeState(subcircuitState);
        if (this.pinListeners.containsKey(subcircuitState)) {
            Map<Pin, Pin.PinChangeListener> listeners = this.pinListeners.get(subcircuitState);
            this.pins.forEach(pin -> {
                if (listeners.containsKey(pin)) {
                    pin.removeChangeListener(subcircuitState, (Pin.PinChangeListener)listeners.get(pin));
                }
            });
        }
    }

    public Port getPort(Pin pin) {
        int index = this.pins.indexOf(pin);
        if (index == -1) {
            return null;
        }
        return this.getPort(index);
    }

    @Override
    public void valueChanged(CircuitState state, WireValue value, int portIndex) {
        CircuitState subcircuitState = (CircuitState)state.getComponentProperty(this);
        Pin pin = this.pins.get(portIndex);
        if (pin.isInput() && pin.getCircuit() != null) {
            subcircuitState.pushValue(pin.getPort(0), value);
        }
    }
}

