/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator;

import com.ra4king.circuitsim.simulator.ShortCircuitException;

public class WireValue {
    private State[] bits;

    public WireValue(int bitSize) {
        this(bitSize, State.X);
    }

    public WireValue(int bitSize, State state) {
        this.bits = new State[bitSize];
        this.setAllBits(state);
    }

    public WireValue(State ... states) {
        this.bits = states;
    }

    public WireValue(WireValue value) {
        this.bits = new State[value.bits.length];
        System.arraycopy(value.bits, 0, this.bits, 0, this.bits.length);
    }

    public WireValue(WireValue value, int newSize) {
        this.bits = new State[newSize];
        this.setAllBits(State.ZERO);
        System.arraycopy(value.bits, 0, this.bits, 0, newSize < value.bits.length ? newSize : value.bits.length);
    }

    public WireValue merge(WireValue value) {
        if (value.getBitSize() != this.getBitSize()) {
            throw new IllegalStateException("Different size wires detected: wanted " + this.getBitSize() + ", found " + value.getBitSize());
        }
        for (int i = 0; i < this.getBitSize(); ++i) {
            if (this.getBit(i) == State.X) {
                this.setBit(i, value.getBit(i));
                continue;
            }
            if (value.getBit(i) == State.X) {
                this.setBit(i, this.getBit(i));
                continue;
            }
            if (value.getBit(i) == this.getBit(i)) continue;
            throw new ShortCircuitException(this, value);
        }
        return this;
    }

    public static WireValue of(long value, int bitSize) {
        WireValue wireValue = new WireValue(bitSize);
        for (int i = bitSize - 1; i >= 0; --i) {
            if ((value & (long)(1 << i)) == 0L) {
                wireValue.setBit(i, State.ZERO);
                continue;
            }
            wireValue.setBit(i, State.ONE);
        }
        return wireValue;
    }

    public void setAllBits(State state) {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = state;
        }
    }

    public int getBitSize() {
        return this.bits.length;
    }

    public void setBitSize(int bitSize) {
        State[] oldBits = this.bits;
        this.bits = new State[bitSize];
        this.setAllBits(State.X);
        System.arraycopy(oldBits, 0, this.bits, 0, bitSize < oldBits.length ? bitSize : oldBits.length);
    }

    public State getBit(int index) {
        return this.bits[index];
    }

    public void setBit(int index, State state) {
        this.bits[index] = state;
    }

    public WireValue set(WireValue other) {
        if (other.getBitSize() != this.getBitSize()) {
            throw new IllegalArgumentException("Cannot set wire of different size bits. Wanted: " + this.bits.length + ", Found: " + other.bits.length);
        }
        System.arraycopy(other.bits, 0, this.bits, 0, this.bits.length);
        return this;
    }

    public WireValue slice(int offset, int length) {
        if (offset <= 0 || offset + length > this.bits.length) {
            throw new IllegalArgumentException("Incorrect offset and length: " + offset + ", " + length);
        }
        WireValue value = new WireValue(length);
        for (int i = offset; i < offset + length; ++i) {
            value.setBit(i - offset, this.bits[i]);
        }
        return value;
    }

    public boolean isValidValue() {
        if (this.bits.length == 0) {
            return false;
        }
        for (State bit : this.bits) {
            if (bit != State.X) continue;
            return false;
        }
        return true;
    }

    public int getValue() {
        int value = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == State.X) {
                throw new IllegalStateException("Invalid value");
            }
            value |= (1 << i) * (this.bits[i] == State.ONE ? 1 : 0);
        }
        return value;
    }

    public String toHexString() {
        String value;
        int hexDigits = 1 + (this.getBitSize() - 1) / 4;
        if (this.isValidValue()) {
            value = String.format("%0" + hexDigits + "x", this.getValue());
        } else {
            value = "";
            for (int i = 0; i < hexDigits; ++i) {
                value = value + "x";
            }
        }
        return value;
    }

    public boolean equals(Object other) {
        if (other instanceof WireValue) {
            WireValue value = (WireValue)other;
            if (value.getBitSize() != this.getBitSize()) {
                return false;
            }
            for (int i = 0; i < this.getBitSize(); ++i) {
                if (this.getBit(i) == value.getBit(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = this.getBitSize() - 1; i >= 0; --i) {
            builder.append(this.getBit((int)i).repr);
        }
        return builder.toString();
    }

    public static enum State {
        ONE('1'),
        ZERO('0'),
        X('x');

        public final char repr;

        private State(char c) {
            this.repr = c;
        }

        public State negate() {
            return this == X ? X : (this == ONE ? ZERO : ONE);
        }
    }
}

