/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator;

import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.OscillationException;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.ShortCircuitException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class Simulator {
    private Set<Circuit> circuits;
    private Collection<Pair<CircuitState, Port.Link>> linksToUpdate;
    private Collection<Pair<CircuitState, Port.Link>> temp;
    private Collection<Pair<CircuitState, Port.Link>> shortCircuited;
    private ShortCircuitException lastShortCircuit;
    private final Set<Collection<Pair<CircuitState, Port.Link>>> history;
    private final ReentrantLock lock = new ReentrantLock(true);
    private boolean tmp;
    private boolean stepping = false;

    public Simulator() {
        this.circuits = new HashSet<Circuit>();
        this.linksToUpdate = new LinkedHashSet<Pair<CircuitState, Port.Link>>();
        this.temp = new LinkedHashSet<Pair<CircuitState, Port.Link>>();
        this.shortCircuited = new ArrayList<Pair<CircuitState, Port.Link>>();
        this.history = new HashSet<Collection<Pair<CircuitState, Port.Link>>>();
    }

    public Lock getLock() {
        return this.lock;
    }

    public void runSync(Runnable runnable) {
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Collection<Pair<CircuitState, Port.Link>> getLinksToUpdate() {
        return this.linksToUpdate;
    }

    public boolean hasLinksToUpdate() {
        this.runSync(() -> {
            this.tmp = !this.linksToUpdate.isEmpty();
        });
        return this.tmp;
    }

    public void clear() {
        this.runSync(() -> {
            this.circuits.clear();
            this.linksToUpdate.clear();
            this.temp.clear();
            this.shortCircuited.clear();
            this.history.clear();
        });
    }

    public void reset() {
        this.runSync(() -> this.circuits.forEach(circuit -> circuit.forEachState(CircuitState::reset)));
    }

    public Set<Circuit> getCircuits() {
        return this.circuits;
    }

    public void addCircuit(Circuit circuit) {
        this.runSync(() -> this.circuits.add(circuit));
    }

    public void removeCircuit(Circuit circuit) {
        this.runSync(() -> this.circuits.remove(circuit));
    }

    public void valueChanged(CircuitState state, Port port) {
        this.valueChanged(state, port.getLink());
    }

    public void valueChanged(CircuitState state, Port.Link link) {
        this.runSync(() -> this.linksToUpdate.add((Pair<CircuitState, Port.Link>)new Pair((Object)state, (Object)link)));
    }

    void linkRemoved(Port.Link link) {
        this.runSync(() -> this.linksToUpdate.removeAll(this.linksToUpdate.stream().filter(pair -> pair.getValue() == link).collect(Collectors.toList())));
    }

    public void step() {
        this.runSync(() -> {
            if (this.stepping) {
                return;
            }
            try {
                this.stepping = true;
                Collection<Pair<CircuitState, Port.Link>> tmp = this.linksToUpdate;
                this.linksToUpdate = this.temp;
                this.temp = tmp;
                this.temp.addAll(this.shortCircuited);
                this.linksToUpdate.clear();
                this.shortCircuited.clear();
                this.lastShortCircuit = null;
                this.temp.forEach(pair -> {
                    CircuitState state = (CircuitState)pair.getKey();
                    Port.Link link = (Port.Link)pair.getValue();
                    if (link.getCircuit() == null || !state.getCircuit().containsState(state)) {
                        return;
                    }
                    try {
                        state.propagateSignal(link);
                    }
                    catch (ShortCircuitException exc) {
                        this.shortCircuited.add((Pair<CircuitState, Port.Link>)pair);
                        this.lastShortCircuit = exc;
                    }
                });
                if (this.lastShortCircuit != null && this.linksToUpdate.isEmpty()) {
                    throw this.lastShortCircuit;
                }
                this.linksToUpdate.addAll(this.shortCircuited);
            }
            finally {
                this.stepping = false;
            }
        });
    }

    public void stepAll() {
        this.runSync(() -> {
            if (this.stepping) {
                return;
            }
            this.history.clear();
            int repeatCount = 0;
            while (!this.linksToUpdate.isEmpty()) {
                if (this.history.contains(this.linksToUpdate) && ++repeatCount == 10) {
                    throw new OscillationException();
                }
                this.history.add(new LinkedHashSet<Pair<CircuitState, Port.Link>>(this.linksToUpdate));
                this.step();
            }
        });
    }
}

