/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator;

import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.Component;
import java.util.HashSet;
import java.util.Set;

public class Port {
    private final Component component;
    private final int portIndex;
    private Link link;

    public Port(Component component, int portIndex, int bitSize) {
        this.component = component;
        this.portIndex = portIndex;
        this.link = new Link(bitSize);
        this.link.participants.add(this);
    }

    public Component getComponent() {
        return this.component;
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    public Link getLink() {
        return this.link;
    }

    public Port linkPort(Port port) {
        this.link.linkPort(port);
        return this;
    }

    public Port unlinkPort(Port port) {
        this.link.unlinkPort(port);
        return this;
    }

    public String toString() {
        return "Port(" + this.component + "[" + this.portIndex + "])";
    }

    public static class Link {
        private final Set<Port> participants = new HashSet<Port>();
        private final int bitSize;

        public Link(int bitSize) {
            this.bitSize = bitSize;
        }

        public Circuit getCircuit() {
            return this.participants.isEmpty() ? null : this.participants.iterator().next().component.getCircuit();
        }

        public int getBitSize() {
            return this.bitSize;
        }

        public Set<Port> getParticipants() {
            return this.participants;
        }

        public Link linkPort(Port port) {
            if (this.participants.contains(port)) {
                return this;
            }
            Circuit circuit = this.getCircuit();
            if (circuit == null) {
                throw new IllegalStateException("Link does not belong to a circuit.");
            }
            if (port.getLink().getCircuit() == null) {
                throw new IllegalStateException("Port does not belong to a circuit.");
            }
            if (port.getLink().getCircuit() != circuit) {
                throw new IllegalArgumentException("Links belong to different circuits.");
            }
            if (port.getLink().bitSize != this.bitSize) {
                throw new IllegalArgumentException("Links have different bit sizes.");
            }
            circuit.forEachState(state -> state.link(this, port.getLink()));
            Set<Port> portParticipants = port.getLink().participants;
            this.participants.addAll(portParticipants);
            for (Port p : portParticipants) {
                p.link = this;
            }
            return this;
        }

        public Link unlinkPort(Port port) {
            if (!this.participants.contains(port)) {
                return this;
            }
            if (this.participants.size() == 1) {
                return this;
            }
            Circuit circuit = this.getCircuit();
            this.participants.remove(port);
            port.link = new Link(this.bitSize);
            ((Port)port).link.participants.add(port);
            circuit.forEachState(state -> state.unlink(this, port));
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Link[");
            this.participants.forEach(port -> builder.append(port).append(","));
            return builder.deleteCharAt(builder.length() - 1).append("]").toString();
        }
    }
}

