/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator;

import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;

public abstract class Component {
    private Circuit circuit;
    private Port[] ports;
    private String name;

    protected Component(String name, int[] portBits) {
        this.name = name;
        this.ports = new Port[portBits.length];
        for (int i = 0; i < portBits.length; ++i) {
            this.ports[i] = new Port(this, i, portBits[i]);
        }
    }

    public void setCircuit(Circuit circuit) {
        this.circuit = circuit;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Port getPort(int portIndex) {
        return this.ports[portIndex];
    }

    public int getNumPorts() {
        return this.ports.length;
    }

    public void init(CircuitState circuitState, Object lastProperty) {
    }

    public void uninit(CircuitState circuitState) {
    }

    public abstract void valueChanged(CircuitState var1, WireValue var2, int var3);

    public String toString() {
        return this.name.isEmpty() ? this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) : this.name;
    }
}

