/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator;

import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.ShortCircuitException;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class CircuitState {
    private Circuit circuit;
    private Map<Component, Object> componentProperties;
    private Map<Port.Link, LinkState> linkStates;
    private final boolean readOnly;

    public CircuitState(Circuit circuit) {
        if (circuit == null) {
            throw new NullPointerException("Circuit cannot be null.");
        }
        this.readOnly = false;
        circuit.getSimulator().runSync(() -> {
            this.circuit = circuit;
            this.componentProperties = new HashMap<Component, Object>();
            this.linkStates = new HashMap<Port.Link, LinkState>();
            circuit.addState(this);
        });
    }

    public CircuitState(CircuitState state) {
        this.readOnly = true;
        state.circuit.getSimulator().runSync(() -> {
            this.circuit = state.circuit;
            this.componentProperties = new HashMap<Component, Object>(state.componentProperties);
            this.linkStates = new HashMap<Port.Link, LinkState>();
            state.linkStates.forEach((link, linkState) -> this.linkStates.put((Port.Link)link, new LinkState((LinkState)linkState)));
        });
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public Map<Component, Object> getComponentProperties() {
        return this.componentProperties;
    }

    public Object getComponentProperty(Component component) {
        return this.componentProperties.get(component);
    }

    public void putComponentProperty(Component component, Object property) {
        this.componentProperties.put(component, property);
    }

    public Object removeComponentProperty(Component component) {
        return this.componentProperties.remove(component);
    }

    public WireValue getMergedValue(Port.Link link) {
        return this.get(link).getMergedValue();
    }

    public WireValue getLastReceived(Port port) {
        return new WireValue(this.get(port.getLink()).getLastReceived(port));
    }

    public WireValue getLastPushed(Port port) {
        return new WireValue(this.get(port.getLink()).getLastPushed(port));
    }

    public boolean isShortCircuited(Port.Link link) {
        return this.get(link).isShortCircuit();
    }

    public void reset() {
        this.linkStates.putAll(this.linkStates.keySet().stream().collect(Collectors.toMap(link -> link, x$0 -> new LinkState((Port.Link)x$0))));
        this.circuit.getComponents().forEach(c -> {
            try {
                c.uninit(this);
                c.init(this, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private LinkState get(Port.Link link) {
        if (!this.linkStates.containsKey(link)) {
            if (link.getCircuit() == null) {
                throw new IllegalArgumentException("Link has no circuit!");
            }
            if (link.getCircuit() != this.circuit) {
                throw new IllegalArgumentException("Link not from this circuit.");
            }
            LinkState linkState = new LinkState(link);
            this.linkStates.put(link, linkState);
            return linkState;
        }
        return this.linkStates.get(link);
    }

    void link(Port.Link link1, Port.Link link2) {
        this.circuit.getSimulator().runSync(() -> this.get(link1).link(this.get(link2)));
    }

    void unlink(Port.Link link, Port port) {
        this.circuit.getSimulator().runSync(() -> this.get(link).unlink(port));
    }

    void propagateSignal(Port.Link link) {
        LinkState linkState = this.get(link);
        linkState.participants.forEach((port, info) -> {
            WireValue lastMerged = info.lastMerged;
            WireValue lastPushed = info.lastPushed;
            if (!lastMerged.equals(lastPushed)) {
                linkState.cachedMergedValue = null;
                linkState.isShortCircuited = null;
                lastMerged.set(lastPushed);
            }
        });
        linkState.propagate();
    }

    public void pushValue(Port port, WireValue value) {
        if (this.readOnly) {
            throw new IllegalStateException("This CircuitState is read-only");
        }
        this.circuit.getSimulator().runSync(() -> {
            LinkState linkState = this.get(port.getLink());
            WireValue lastPushed = linkState.getLastPushed(port);
            if (!value.equals(lastPushed)) {
                lastPushed.set(value);
                this.circuit.getSimulator().valueChanged(this, port);
            }
        });
    }

    void ensureUnlinked(Component component, boolean removeLinks) {
        for (int i = 0; i < component.getNumPorts(); ++i) {
            Port port = component.getPort(i);
            Port.Link link = port.getLink();
            if (link != null && this.linkStates.containsKey(link) && this.linkStates.get((Object)link).participants.size() > 1) {
                throw new RuntimeException("Must unlink port before removing it.");
            }
            if (!removeLinks) continue;
            this.linkStates.remove(link);
            this.circuit.getSimulator().linkRemoved(link);
        }
    }

    class LinkState {
        final Port.Link link;
        final HashMap<Port, PortStateInfo> participants;
        WireValue cachedMergedValue;
        Boolean isShortCircuited;

        LinkState(Port.Link link) {
            this.link = link;
            this.participants = new HashMap();
            link.getParticipants().forEach(port -> this.participants.put((Port)port, new PortStateInfo()));
        }

        LinkState(LinkState linkState) {
            this.link = linkState.link;
            this.participants = new HashMap();
            linkState.participants.forEach((port, info) -> this.participants.put((Port)port, new PortStateInfo((PortStateInfo)info)));
        }

        WireValue getLastPushed(Port port) {
            return this.participants.get((Object)port).lastPushed;
        }

        WireValue getLastMerged(Port port) {
            return this.participants.get((Object)port).lastMerged;
        }

        WireValue getLastReceived(Port port) {
            return this.participants.get((Object)port).lastReceived;
        }

        WireValue getIncomingValue(Port port) {
            WireValue newValue = new WireValue(this.link.getBitSize());
            this.participants.forEach((p, info) -> {
                if (p != port) {
                    newValue.merge(info.lastMerged);
                }
            });
            return newValue;
        }

        WireValue getMergedValue() {
            if (this.cachedMergedValue != null) {
                return this.cachedMergedValue;
            }
            WireValue newValue = new WireValue(this.link.getBitSize());
            this.participants.values().forEach(info -> newValue.merge(info.lastMerged));
            this.cachedMergedValue = new WireValue(newValue);
            this.isShortCircuited = null;
            return newValue;
        }

        boolean isShortCircuit() {
            try {
                if (this.isShortCircuited != null) {
                    return this.isShortCircuited;
                }
                this.getMergedValue();
                this.isShortCircuited = false;
                return this.isShortCircuited;
            }
            catch (ShortCircuitException exc) {
                this.isShortCircuited = true;
                return this.isShortCircuited;
            }
            catch (Throwable t) {
                this.isShortCircuited = false;
                return this.isShortCircuited;
            }
        }

        void propagate() {
            HashMap<Port, WireValue> toNotify = new HashMap<Port, WireValue>();
            ShortCircuitException shortCircuit = null;
            for (Port participantPort : this.participants.keySet()) {
                WireValue incomingValue;
                try {
                    incomingValue = this.getIncomingValue(participantPort);
                }
                catch (ShortCircuitException exc) {
                    shortCircuit = exc;
                    continue;
                }
                WireValue lastReceived = this.getLastReceived(participantPort);
                if (lastReceived.equals(incomingValue)) continue;
                lastReceived.set(incomingValue);
                toNotify.put(participantPort, incomingValue);
            }
            RuntimeException exception = null;
            for (Map.Entry entry : toNotify.entrySet()) {
                Port participantPort = (Port)entry.getKey();
                WireValue incomingValue = (WireValue)entry.getValue();
                try {
                    participantPort.getComponent().valueChanged(CircuitState.this, incomingValue, participantPort.getPortIndex());
                }
                catch (ShortCircuitException exc) {
                    shortCircuit = exc;
                }
                catch (RuntimeException exc) {
                    exc.printStackTrace();
                    if (exception != null) continue;
                    exception = exc;
                }
            }
            if (exception != null) {
                throw exception;
            }
            if (shortCircuit != null) {
                throw shortCircuit;
            }
            this.getMergedValue();
        }

        void link(LinkState other) {
            if (this == other) {
                return;
            }
            this.participants.putAll(other.participants);
            this.cachedMergedValue = null;
            this.isShortCircuited = null;
            this.participants.forEach((port, info) -> info.lastMerged.setAllBits(WireValue.State.X));
            CircuitState.this.linkStates.remove(other.link);
            CircuitState.this.getCircuit().getSimulator().linkRemoved(other.link);
            CircuitState.this.getCircuit().getSimulator().valueChanged(CircuitState.this, this.link);
        }

        void unlink(Port port) {
            if (!this.participants.containsKey(port)) {
                return;
            }
            this.cachedMergedValue = null;
            this.isShortCircuited = null;
            PortStateInfo info = this.participants.remove(port);
            ((CircuitState)CircuitState.this).get((Port.Link)port.getLink()).participants.put(port, new PortStateInfo(info.lastPushed, new WireValue(info.lastPushed), new WireValue(this.link.getBitSize())));
            RuntimeException exception = null;
            WireValue newValue = new WireValue(this.link.getBitSize());
            if (!info.lastReceived.equals(newValue)) {
                info.lastReceived.set(newValue);
                try {
                    port.getComponent().valueChanged(CircuitState.this, newValue, port.getPortIndex());
                }
                catch (RuntimeException exc) {
                    exception = exc;
                }
            }
            if (this.participants.isEmpty()) {
                CircuitState.this.linkStates.remove(this.link);
                CircuitState.this.getCircuit().getSimulator().linkRemoved(this.link);
            } else {
                CircuitState.this.getCircuit().getSimulator().valueChanged(CircuitState.this, this.link);
            }
            if (exception != null) {
                throw exception;
            }
        }

        class PortStateInfo {
            WireValue lastPushed;
            WireValue lastMerged;
            WireValue lastReceived;

            PortStateInfo() {
                this(new WireValue(this$1.link.getBitSize()), new WireValue(this$1.link.getBitSize()), new WireValue(this$1.link.getBitSize()));
            }

            PortStateInfo(PortStateInfo info) {
                this(new WireValue(info.lastPushed), new WireValue(info.lastMerged), new WireValue(info.lastReceived));
            }

            PortStateInfo(WireValue lastPushed, WireValue lastMerged, WireValue lastReceived) {
                this.lastPushed = lastPushed;
                this.lastMerged = lastMerged;
                this.lastReceived = lastReceived;
            }
        }
    }
}

