/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.simulator;

import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Simulator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

public class Circuit {
    private String name;
    private final Simulator simulator;
    private final Set<Component> components;
    private final Set<CircuitState> states;
    private final CircuitState topLevelState;
    private final Queue<CircuitChangeListener> listeners = new ConcurrentLinkedQueue<CircuitChangeListener>();
    private RuntimeException exception = null;

    public Circuit(String name, Simulator simulator) {
        this.name = name;
        this.simulator = simulator;
        simulator.addCircuit(this);
        this.components = new HashSet<Component>();
        this.states = new HashSet<CircuitState>();
        this.topLevelState = new CircuitState(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public <T extends Component> T addComponent(T component) {
        this.simulator.runSync(() -> {
            if (component.getCircuit() == this) {
                return;
            }
            if (component.getCircuit() != null) {
                throw new IllegalArgumentException("Component already belongs to a circuit.");
            }
            component.setCircuit(this);
            this.components.add(component);
            this.states.forEach(state -> {
                block2: {
                    try {
                        component.init((CircuitState)state, state.getComponentProperty(component));
                    }
                    catch (RuntimeException exc) {
                        if (this.exception != null) break block2;
                        this.exception = exc;
                    }
                }
            });
            this.listeners.forEach(listener -> listener.circuitChanged(this, component, true));
        });
        if (this.exception != null) {
            RuntimeException exc = this.exception;
            this.exception = null;
            throw exc;
        }
        return component;
    }

    public <T extends Component> void updateComponent(T oldComponent, T newComponent, Runnable inBetween) {
        this.simulator.runSync(() -> {
            this.states.forEach(state -> state.ensureUnlinked(oldComponent, false));
            this.components.remove(oldComponent);
            this.states.forEach(state -> {
                block2: {
                    try {
                        oldComponent.uninit((CircuitState)state);
                    }
                    catch (RuntimeException exc) {
                        if (this.exception != null) break block2;
                        this.exception = exc;
                    }
                }
            });
            oldComponent.setCircuit(null);
            this.listeners.forEach(listener -> listener.circuitChanged(this, oldComponent, false));
            if (inBetween != null) {
                inBetween.run();
            }
            newComponent.setCircuit(this);
            this.components.add(newComponent);
            this.states.forEach(state -> {
                block2: {
                    try {
                        newComponent.init((CircuitState)state, state.getComponentProperty(oldComponent));
                    }
                    catch (RuntimeException exc) {
                        if (this.exception != null) break block2;
                        this.exception = exc;
                    }
                }
            });
            this.listeners.forEach(listener -> listener.circuitChanged(this, newComponent, true));
        });
        if (this.exception != null) {
            RuntimeException exc = this.exception;
            this.exception = null;
            throw exc;
        }
    }

    public void removeComponent(Component component) {
        this.simulator.runSync(() -> {
            if (!this.components.contains(component)) {
                return;
            }
            this.states.forEach(state -> state.ensureUnlinked(component, true));
            this.components.remove(component);
            this.states.forEach(state -> {
                block2: {
                    try {
                        component.uninit((CircuitState)state);
                    }
                    catch (RuntimeException exc) {
                        if (this.exception != null) break block2;
                        this.exception = exc;
                    }
                }
            });
            component.setCircuit(null);
            this.listeners.forEach(listener -> listener.circuitChanged(this, component, false));
        });
        if (this.exception != null) {
            RuntimeException exc = this.exception;
            this.exception = null;
            throw exc;
        }
    }

    public Set<Component> getComponents() {
        return this.components;
    }

    public void clearComponents() {
        this.simulator.runSync(() -> new HashSet<Component>(this.components).forEach(this::removeComponent));
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public CircuitState getTopLevelState() {
        return this.topLevelState;
    }

    public void addState(CircuitState state) {
        this.states.add(state);
    }

    public boolean containsState(CircuitState state) {
        return this.states.contains(state);
    }

    public void removeState(CircuitState state) {
        this.states.remove(state);
    }

    public void forEachState(Consumer<CircuitState> consumer) {
        this.states.forEach(consumer);
    }

    public void addListener(CircuitChangeListener listener) {
        this.listeners.add(listener);
    }

    public Collection<CircuitChangeListener> getListeners() {
        return this.listeners;
    }

    public void removeListener(CircuitChangeListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "Circuit " + this.name;
    }

    public static interface CircuitChangeListener {
        public void circuitChanged(Circuit var1, Component var2, boolean var3);
    }
}

