/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.wiring;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class Tunnel
extends ComponentPeer<Component> {
    private static Map<Circuit, Map<String, Set<Tunnel>>> tunnels = new HashMap<Circuit, Map<String, Set<Tunnel>>>();
    private final Component tunnel;
    private final String label;
    private final int bitSize;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Tunnel"), new Image(Tunnel.class.getResourceAsStream("/resources/Tunnel.png")), new Properties(new Properties.Property<Properties.Direction>(Properties.DIRECTION, Properties.Direction.WEST)));
    }

    public Tunnel(Properties props, int x, int y) {
        super(x, y, 0, 2);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.mergeIfExists(props);
        this.label = properties.getValue(Properties.LABEL);
        this.bitSize = properties.getValue(Properties.BITSIZE);
        Bounds bounds = GuiUtils.getBounds(GuiUtils.getFont(13), this.label);
        this.setWidth(Math.max((int)Math.ceil(bounds.getWidth() / 10.0), 1));
        this.tunnel = new Component(this.label, new int[]{this.bitSize}){

            @Override
            public void setCircuit(Circuit circuit) {
                Circuit oldCircuit = this.getCircuit();
                super.setCircuit(circuit);
                if (Tunnel.this.label.isEmpty()) {
                    return;
                }
                if (circuit != null) {
                    Map tunnelSet = tunnels.computeIfAbsent(circuit, l -> new HashMap());
                    Set toNotify = tunnelSet.computeIfAbsent(Tunnel.this.label, c -> new HashSet());
                    toNotify.add(Tunnel.this);
                } else {
                    Set toNotify;
                    Map tunnelSet = (Map)tunnels.get(oldCircuit);
                    if (tunnelSet != null && (toNotify = (Set)tunnelSet.get(Tunnel.this.label)) != null) {
                        toNotify.remove(Tunnel.this);
                        if (toNotify.isEmpty()) {
                            tunnelSet.remove(Tunnel.this.label);
                            if (tunnelSet.isEmpty()) {
                                tunnels.remove(oldCircuit);
                            }
                        }
                    }
                }
            }

            @Override
            public void init(CircuitState state, Object lastProperty) {
                if (Tunnel.this.label.isEmpty()) {
                    return;
                }
                Map tunnelSet = (Map)tunnels.get(this.getCircuit());
                if (tunnelSet != null) {
                    Set toNotify = (Set)tunnelSet.get(Tunnel.this.label);
                    WireValue value = new WireValue(Tunnel.this.bitSize);
                    for (Tunnel tunnel : toNotify) {
                        Port port;
                        WireValue portValue;
                        if (tunnel == Tunnel.this || (portValue = state.getLastReceived(port = ((Component)tunnel.getComponent()).getPort(0))).getBitSize() != value.getBitSize()) continue;
                        try {
                            value.merge(portValue);
                        }
                        catch (Exception exc) {
                            return;
                        }
                    }
                    state.pushValue(this.getPort(0), value);
                }
            }

            @Override
            public void uninit(CircuitState state) {
                Set toNotify;
                Map tunnelSet = (Map)tunnels.get(this.getCircuit());
                if (tunnelSet != null && (toNotify = (Set)tunnelSet.get(Tunnel.this.label)) != null) {
                    block2: for (Tunnel tunnel : toNotify) {
                        if (tunnel.bitSize != Tunnel.this.bitSize) continue;
                        WireValue combined = new WireValue(Tunnel.this.bitSize);
                        for (Tunnel otherTunnel : toNotify) {
                            Port port;
                            WireValue portValue;
                            if (tunnel == otherTunnel || otherTunnel == Tunnel.this || (portValue = state.getLastReceived(port = ((Component)otherTunnel.getComponent()).getPort(0))).getBitSize() != combined.getBitSize()) continue;
                            try {
                                combined.merge(portValue);
                            }
                            catch (Exception exc) {
                                continue block2;
                            }
                        }
                        state.pushValue(((Component)tunnel.getComponent()).getPort(0), combined);
                    }
                }
            }

            @Override
            public void valueChanged(CircuitState state, WireValue value, int portIndex) {
                Map tunnelSet = (Map)tunnels.get(this.getCircuit());
                if (tunnelSet != null && tunnelSet.containsKey(Tunnel.this.label)) {
                    Set toNotify = (Set)tunnelSet.get(Tunnel.this.label);
                    block2: for (Tunnel tunnel : toNotify) {
                        if (tunnel == Tunnel.this || tunnel.bitSize != Tunnel.this.bitSize) continue;
                        WireValue combined = value;
                        if (toNotify.size() > 2) {
                            combined = new WireValue(Tunnel.this.bitSize);
                            for (Tunnel otherTunnel : toNotify) {
                                Port port;
                                WireValue portValue;
                                if (tunnel == otherTunnel || (portValue = state.getLastReceived(port = ((Component)otherTunnel.getComponent()).getPort(0))).getBitSize() != combined.getBitSize()) continue;
                                try {
                                    combined.merge(portValue);
                                }
                                catch (Exception exc) {
                                    continue block2;
                                }
                            }
                        }
                        state.pushValue(((Component)tunnel.getComponent()).getPort(0), combined);
                    }
                }
            }
        };
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: {
                this.setWidth(this.getWidth() + 2);
                connections.add(new Connection.PortConnection(this, this.tunnel.getPort(0), this.getWidth(), this.getHeight() / 2));
                break;
            }
            case WEST: {
                this.setWidth(this.getWidth() + 2);
                connections.add(new Connection.PortConnection(this, this.tunnel.getPort(0), 0, this.getHeight() / 2));
                break;
            }
            case NORTH: {
                this.setWidth(Math.max((this.getWidth() - 1) / 2 * 2 + 2, 2));
                this.setHeight(3);
                connections.add(new Connection.PortConnection(this, this.tunnel.getPort(0), this.getWidth() / 2, 0));
                break;
            }
            case SOUTH: {
                this.setWidth(Math.max((this.getWidth() - 1) / 2 * 2 + 2, 2));
                this.setHeight(3);
                connections.add(new Connection.PortConnection(this, this.tunnel.getPort(0), this.getWidth() / 2, this.getHeight()));
            }
        }
        this.init(this.tunnel, properties, connections);
    }

    private boolean isIncompatible() {
        Map<String, Set<Tunnel>> tunnelSet = tunnels.get(this.tunnel.getCircuit());
        if (tunnelSet != null && tunnelSet.containsKey(this.label)) {
            for (Tunnel tunnel : tunnelSet.get(this.label)) {
                if (tunnel.bitSize == this.bitSize) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        Properties.Direction direction = this.getProperties().getValue(Properties.DIRECTION);
        boolean isIncompatible = this.isIncompatible();
        graphics.setStroke((Paint)Color.BLACK);
        graphics.setFill((Paint)(isIncompatible ? Color.ORANGE : Color.WHITE));
        int block = 10;
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        int xOff = 0;
        int yOff = 0;
        switch (direction) {
            case EAST: {
                xOff = -block;
                graphics.beginPath();
                graphics.moveTo((double)(x + width), (double)y + (double)height * 0.5);
                graphics.lineTo((double)(x + width - block), (double)(y + height));
                graphics.lineTo((double)x, (double)(y + height));
                graphics.lineTo((double)x, (double)y);
                graphics.lineTo((double)(x + width - block), (double)y);
                graphics.closePath();
                break;
            }
            case WEST: {
                xOff = block;
                graphics.beginPath();
                graphics.moveTo((double)x, (double)y + (double)height * 0.5);
                graphics.lineTo((double)(x + block), (double)y);
                graphics.lineTo((double)(x + width), (double)y);
                graphics.lineTo((double)(x + width), (double)(y + height));
                graphics.lineTo((double)(x + block), (double)(y + height));
                graphics.closePath();
                break;
            }
            case NORTH: {
                yOff = block;
                graphics.beginPath();
                graphics.moveTo((double)x + (double)width * 0.5, (double)y);
                graphics.lineTo((double)(x + width), (double)(y + block));
                graphics.lineTo((double)(x + width), (double)(y + height));
                graphics.lineTo((double)x, (double)(y + height));
                graphics.lineTo((double)x, (double)(y + block));
                graphics.closePath();
                break;
            }
            case SOUTH: {
                yOff = -block;
                graphics.beginPath();
                graphics.moveTo((double)x + (double)width * 0.5, (double)(y + height));
                graphics.lineTo((double)x, (double)(y + height - block));
                graphics.lineTo((double)x, (double)y);
                graphics.lineTo((double)(x + width), (double)y);
                graphics.lineTo((double)(x + width), (double)(y + height - block));
                graphics.closePath();
            }
        }
        graphics.fill();
        graphics.stroke();
        if (!this.label.isEmpty()) {
            Bounds bounds = GuiUtils.getBounds(graphics.getFont(), this.label);
            graphics.setFill((Paint)Color.BLACK);
            graphics.fillText(this.label, (double)(x + xOff) + ((double)(width - xOff) - bounds.getWidth()) * 0.5, (double)(y + yOff) + ((double)(height - yOff) + bounds.getHeight()) * 0.4);
        }
        if (isIncompatible) {
            Connection.PortConnection port = this.getConnections().get(0);
            graphics.setFill((Paint)Color.BLACK);
            graphics.fillText(String.valueOf(this.bitSize), (double)(port.getScreenX() + 11), (double)(port.getScreenY() + 21));
            graphics.setStroke((Paint)Color.ORANGE);
            graphics.setFill((Paint)Color.ORANGE);
            graphics.strokeOval((double)(port.getScreenX() - 2), (double)(port.getScreenY() - 2), 10.0, 10.0);
            graphics.fillText(String.valueOf(this.bitSize), (double)(port.getScreenX() + 10), (double)(port.getScreenY() + 20));
        }
    }
}

