/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.wiring;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.wiring.Transistor;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class TransistorPeer
extends ComponentPeer<Transistor> {
    private static final Properties.Property<Boolean> TRANSISTOR_TYPE_PROPERTY = new Properties.Property<Boolean>("Type", new Properties.PropertyListValidator<Boolean>(Arrays.asList(true, false), val -> val != false ? "P-Type" : "N-Type"), true);
    private static final Properties.Property<Boolean> GATE_LOCATION_PROPERTY = new Properties.Property<Boolean>("Gate Location", Properties.LOCATION_VALIDATOR, true);

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Transistor"), new Image(TransistorPeer.class.getResourceAsStream("/resources/Transistor.png")), new Properties());
    }

    public TransistorPeer(Properties props, int x, int y) {
        super(x, y, 4, 2);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(TRANSISTOR_TYPE_PROPERTY);
        properties.ensureProperty(GATE_LOCATION_PROPERTY);
        properties.mergeIfExists(props);
        Transistor transistor = new Transistor(properties.getValue(Properties.LABEL), properties.getValue(TRANSISTOR_TYPE_PROPERTY));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        int yOff = 0;
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: 
            case NORTH: {
                yOff = properties.getValue(GATE_LOCATION_PROPERTY) != false ? 0 : this.getHeight();
                break;
            }
            case WEST: 
            case SOUTH: {
                yOff = properties.getValue(GATE_LOCATION_PROPERTY) != false ? this.getHeight() : 0;
            }
        }
        connections.add(new Connection.PortConnection(this, transistor.getPort(0), "Input", 0, this.getHeight() - yOff));
        connections.add(new Connection.PortConnection(this, transistor.getPort(1), "Gate", this.getWidth() / 2, yOff));
        connections.add(new Connection.PortConnection(this, transistor.getPort(2), "Output", this.getWidth(), this.getHeight() - yOff));
        GuiUtils.rotatePorts(connections, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        GuiUtils.rotateElementSize(this, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        this.init(transistor, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState state) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        GuiUtils.rotateGraphics(this, graphics, this.getProperties().getValue(Properties.DIRECTION));
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth() > this.getScreenHeight() ? this.getScreenWidth() : this.getScreenHeight();
        int height = this.getScreenWidth() > this.getScreenHeight() ? this.getScreenHeight() : this.getScreenWidth();
        boolean gateLoc = this.getProperties().getValue(GATE_LOCATION_PROPERTY);
        switch (this.getProperties().getValue(Properties.DIRECTION)) {
            case WEST: 
            case SOUTH: {
                gateLoc = !gateLoc;
            }
        }
        int yOff = gateLoc ? 0 : height;
        int m = gateLoc ? 1 : -1;
        graphics.setStroke((Paint)Color.BLACK);
        graphics.setLineWidth(2.0);
        graphics.beginPath();
        graphics.moveTo((double)x, (double)(y + height - yOff));
        graphics.lineTo((double)x + (double)width / 3.0, (double)(y + height - yOff));
        graphics.lineTo((double)x + (double)width / 3.0, (double)(y + yOff) + (double)(m * height) * 0.7);
        graphics.lineTo((double)x + 2.0 * (double)width / 3.0, (double)(y + yOff) + (double)(m * height) * 0.7);
        graphics.lineTo((double)x + 2.0 * (double)width / 3.0, (double)(y + height - yOff));
        graphics.lineTo((double)(x + width), (double)(y + height - yOff));
        graphics.moveTo((double)x + (double)width / 3.0, (double)(y + yOff) + (double)(m * height) * 0.5);
        graphics.lineTo((double)x + 2.0 * (double)width / 3.0, (double)(y + yOff) + (double)(m * height) * 0.5);
        graphics.stroke();
        graphics.setLineWidth(1.0);
        graphics.beginPath();
        graphics.moveTo((double)x + (double)width * 0.5 - 1.5, (double)(y + yOff) + (double)m * ((double)height * 0.7 + 3.0));
        graphics.lineTo((double)x + (double)width * 0.5 + 3.0, (double)(y + yOff) + (double)m * ((double)height * 0.7 + 5.0));
        graphics.lineTo((double)x + (double)width * 0.5 - 1.5, (double)(y + yOff) + (double)m * ((double)height * 0.7 + 7.0));
        graphics.stroke();
        if (this.getProperties().getValue(TRANSISTOR_TYPE_PROPERTY).booleanValue()) {
            graphics.strokeOval((double)x + (double)width * 0.5 - 3.0, (double)(y + (gateLoc ? 3 : height - 9)), 6.0, 6.0);
        } else {
            graphics.strokeLine((double)x + (double)width * 0.5, (double)(y + yOff), (double)x + (double)width * 0.5, (double)y + (double)height * 0.5);
        }
    }
}

