/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.wiring;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.wiring.Splitter;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class SplitterPeer
extends ComponentPeer<Splitter> {
    private static final Properties.Property<Integer> FANOUTS;
    private static final Properties.Property<Boolean> INPUT_LOCATION;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Splitter"), new Image(SplitterPeer.class.getResourceAsStream("/resources/Splitter.png")), new Properties(new Properties.Property<Integer>(Properties.BITSIZE, 2)));
    }

    public SplitterPeer(Properties props, int x, int y) {
        super(x, y, 2, 0);
        Splitter splitter;
        int i;
        int[] bitFanIndices;
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(INPUT_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(FANOUTS);
        properties.mergeIfExists(props);
        int bitSize = properties.getValue(Properties.BITSIZE);
        int numInputs = properties.getValue(FANOUTS);
        ArrayList<Integer> fanOuts = new ArrayList<Integer>();
        for (int i2 = -1; i2 < numInputs; ++i2) {
            fanOuts.add(i2);
        }
        Properties.PropertyListValidator<Integer> validator = new Properties.PropertyListValidator<Integer>(fanOuts, value -> value == -1 ? "None" : value.toString());
        int availableBits = 0;
        while (props.containsProperty("Bit " + availableBits)) {
            ++availableBits;
        }
        if (availableBits == bitSize) {
            bitFanIndices = new int[bitSize];
            for (i = 0; i < bitFanIndices.length; ++i) {
                Object value2 = props.getValue("Bit " + i);
                int index = value2 == null ? i : (value2 instanceof String ? ((Integer)validator.parse((String)value2)).intValue() : ((Integer)value2).intValue());
                bitFanIndices[i] = Math.min(numInputs - 1, index);
            }
            splitter = new Splitter(properties.getValue(Properties.LABEL), bitFanIndices);
        } else {
            splitter = new Splitter(properties.getValue(Properties.LABEL), bitSize, numInputs);
        }
        this.setHeight(Math.max(2, splitter.getNumPorts()));
        bitFanIndices = splitter.getBitFanIndices();
        for (i = 0; i < bitFanIndices.length; ++i) {
            properties.setProperty(new Properties.Property<Integer>("Bit " + i, validator, bitFanIndices[i]));
        }
        Properties.Direction direction = properties.getValue(Properties.DIRECTION);
        boolean inputOnTopLeft = properties.getValue(INPUT_LOCATION);
        GuiUtils.rotateElementSize(this, Properties.Direction.EAST, direction);
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        for (int i3 = 0; i3 < splitter.getNumPorts() - 1; ++i3) {
            int cy;
            int cx;
            StringBuilder tooltip = new StringBuilder();
            int start = -1;
            for (int j = 0; j < bitFanIndices.length; ++j) {
                if (bitFanIndices[j] == splitter.getNumPorts() - 2 - i3) {
                    if (start != -1 && j != bitFanIndices.length - 1) continue;
                    tooltip.append(start == -1 ? (char)',' : '-').append(j);
                    start = j;
                    continue;
                }
                if (start == -1) continue;
                if (start < j - 1) {
                    tooltip.append('-').append(j - 1);
                }
                start = -1;
            }
            switch (direction) {
                case EAST: {
                    cx = this.getWidth();
                    cy = inputOnTopLeft ? i3 + 2 : this.getHeight() - i3 - 2;
                    break;
                }
                case WEST: {
                    cx = 0;
                    cy = inputOnTopLeft ? i3 + 2 : this.getHeight() - i3 - 2;
                    break;
                }
                case SOUTH: {
                    cx = inputOnTopLeft ? i3 + 2 : this.getWidth() - i3 - 2;
                    cy = this.getHeight();
                    break;
                }
                case NORTH: {
                    cx = inputOnTopLeft ? i3 + 2 : this.getWidth() - i3 - 2;
                    cy = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Why are you doing this?");
                }
            }
            connections.add(new Connection.PortConnection(this, splitter.getPort(splitter.getNumPorts() - 2 - i3), tooltip.length() == 0 ? tooltip.toString() : tooltip.substring(1), cx, cy));
        }
        switch (direction) {
            case EAST: {
                connections.add(new Connection.PortConnection(this, splitter.getPort(splitter.PORT_JOINED), 0, inputOnTopLeft ? 0 : this.getHeight()));
                break;
            }
            case WEST: {
                connections.add(new Connection.PortConnection(this, splitter.getPort(splitter.PORT_JOINED), this.getWidth(), inputOnTopLeft ? 0 : this.getHeight()));
                break;
            }
            case SOUTH: {
                connections.add(new Connection.PortConnection(this, splitter.getPort(splitter.PORT_JOINED), inputOnTopLeft ? 0 : this.getWidth(), 0));
                break;
            }
            case NORTH: {
                connections.add(new Connection.PortConnection(this, splitter.getPort(splitter.PORT_JOINED), inputOnTopLeft ? 0 : this.getWidth(), this.getHeight()));
            }
        }
        this.init(splitter, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        Properties.Direction direction = this.getProperties().getValue(Properties.DIRECTION);
        boolean inputOnTop = this.getProperties().getValue(INPUT_LOCATION);
        switch (direction) {
            case WEST: 
            case SOUTH: {
                inputOnTop = !inputOnTop;
            }
            case EAST: 
            case NORTH: {
                GuiUtils.rotateGraphics(this, graphics, direction);
                int x = this.getScreenX();
                int y = this.getScreenY();
                int height = this.getScreenWidth() > this.getScreenHeight() ? this.getScreenWidth() : this.getScreenHeight();
                graphics.setLineWidth(3.0);
                graphics.setStroke((Paint)Color.BLACK);
                graphics.strokeLine((double)x, (double)(y + (inputOnTop ? 0 : height)), (double)(x + 10), (double)(y + (inputOnTop ? 10 : height - 10)));
                graphics.strokeLine((double)(x + 10), (double)(y + (inputOnTop ? 10 : height - 10)), (double)(x + 10), (double)(y + (inputOnTop ? height : 0)));
                for (int i = 20; i <= height; i += 10) {
                    int offset = inputOnTop ? 0 : 20;
                    graphics.strokeLine((double)(x + 10), (double)(y + i - offset), (double)(x + 20), (double)(y + i - offset));
                }
                break;
            }
        }
    }

    static {
        ArrayList<Integer> fanOuts = new ArrayList<Integer>();
        for (int i = 1; i <= 32; ++i) {
            fanOuts.add(i);
        }
        FANOUTS = new Properties.Property<Integer>("Fanouts", new Properties.PropertyListValidator(fanOuts), 2);
        INPUT_LOCATION = new Properties.Property<Boolean>("Input location", Properties.LOCATION_VALIDATOR, true);
    }
}

