/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.wiring;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class Probe
extends ComponentPeer<Component> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Probe"), new Image(Probe.class.getResourceAsStream("/resources/Probe.png")), new Properties(new Properties.Property<Properties.Direction>(Properties.DIRECTION, Properties.Direction.SOUTH)));
    }

    public Probe(Properties props, int x, int y) {
        super(x, y, 0, 0);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.mergeIfExists(props);
        int bitSize = properties.getValue(Properties.BITSIZE);
        Component probe = new Component(properties.getValue(Properties.LABEL), new int[]{bitSize}){

            @Override
            public void valueChanged(CircuitState state, WireValue value, int portIndex) {
            }
        };
        this.setWidth(Math.max(2, Math.min(8, bitSize)));
        this.setHeight((int)Math.round((double)(1 + (bitSize - 1) / 8) * 1.5));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: {
                connections.add(new Connection.PortConnection(this, probe.getPort(0), this.getWidth(), this.getHeight() / 2));
                break;
            }
            case WEST: {
                connections.add(new Connection.PortConnection(this, probe.getPort(0), 0, this.getHeight() / 2));
                break;
            }
            case NORTH: {
                connections.add(new Connection.PortConnection(this, probe.getPort(0), this.getWidth() / 2, 0));
                break;
            }
            case SOUTH: {
                connections.add(new Connection.PortConnection(this, probe.getPort(0), this.getWidth() / 2, this.getHeight()));
            }
        }
        this.init(probe, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFont(GuiUtils.getFont(16));
        Port port = ((Component)this.getComponent()).getPort(0);
        WireValue value = circuitState.getLastReceived(port);
        if (circuitState.isShortCircuited(port.getLink())) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.setStroke((Paint)Color.WHITE);
        graphics.fillRoundRect((double)this.getScreenX(), (double)this.getScreenY(), (double)this.getScreenWidth(), (double)this.getScreenHeight(), 20.0, 20.0);
        graphics.strokeRoundRect((double)this.getScreenX(), (double)this.getScreenY(), (double)this.getScreenWidth(), (double)this.getScreenHeight(), 20.0, 20.0);
        graphics.setFill((Paint)Color.BLACK);
        GuiUtils.drawValue(graphics, value.toString(), this.getScreenX(), this.getScreenY(), this.getScreenWidth());
    }
}

