/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.wiring;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import com.ra4king.circuitsim.simulator.components.wiring.Pin;
import java.util.ArrayList;
import java.util.Optional;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.Pair;

public class PinPeer
extends ComponentPeer<Pin> {
    public static final Properties.Property<Boolean> IS_INPUT = new Properties.Property<Boolean>("Is input?", Properties.YESNO_VALIDATOR, true);

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Input Pin"), new Image(PinPeer.class.getResourceAsStream("/resources/InputPin.png")), new Properties(new Properties.Property<Boolean>(IS_INPUT, true)));
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Output Pin"), new Image(PinPeer.class.getResourceAsStream("/resources/OutputPin.png")), new Properties(new Properties.Property<Boolean>(IS_INPUT, false), new Properties.Property<Properties.Direction>(Properties.DIRECTION, Properties.Direction.WEST)));
    }

    public PinPeer(Properties props, int x, int y) {
        super(x, y, 0, 0);
        Object value = props.getValue(PinPeer.IS_INPUT.name);
        boolean isInput = value == null ? false : (value instanceof String ? Boolean.parseBoolean((String)value) : (Boolean)value);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(new Properties.Property<Properties.Direction>(Properties.LABEL_LOCATION, isInput ? Properties.Direction.WEST : Properties.Direction.EAST));
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(IS_INPUT);
        properties.mergeIfExists(props);
        Pin pin = new Pin(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE), properties.getValue(IS_INPUT));
        this.setWidth(Math.max(2, Math.min(8, pin.getBitSize())));
        this.setHeight((int)Math.round((double)(1 + (pin.getBitSize() - 1) / 8) * 1.5));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: {
                connections.add(new Connection.PortConnection(this, pin.getPort(0), this.getWidth(), this.getHeight() / 2));
                break;
            }
            case WEST: {
                connections.add(new Connection.PortConnection(this, pin.getPort(0), 0, this.getHeight() / 2));
                break;
            }
            case NORTH: {
                connections.add(new Connection.PortConnection(this, pin.getPort(0), this.getWidth() / 2, 0));
                break;
            }
            case SOUTH: {
                connections.add(new Connection.PortConnection(this, pin.getPort(0), this.getWidth() / 2, this.getHeight()));
            }
        }
        this.init(pin, properties, connections);
    }

    public boolean isInput() {
        return ((Pin)this.getComponent()).isInput();
    }

    @Override
    public void mousePressed(CircuitManager manager, CircuitState state, double x, double y) {
        if (!this.isInput()) {
            return;
        }
        if (state != manager.getCircuit().getTopLevelState()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.initOwner((Window)manager.getSimulatorWindow().getStage());
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle("Switch to top-level state?");
            alert.setHeaderText("Switch to top-level state?");
            alert.setContentText("Cannot modify state of a subcircuit. Switch to top-level state?");
            Optional buttonType = alert.showAndWait();
            if (buttonType.isPresent() && buttonType.get() == ButtonType.OK) {
                state = manager.getCircuit().getTopLevelState();
                manager.getCircuitBoard().setCurrentState(state);
            } else {
                return;
            }
        }
        Pin pin = (Pin)this.getComponent();
        WireValue value = state.getLastPushed(pin.getPort(0));
        if (pin.getBitSize() == 1) {
            pin.setValue(state, new WireValue(1, value.getBit(0) == WireValue.State.ONE ? WireValue.State.ZERO : WireValue.State.ONE));
        } else {
            double bitWidth = (double)this.getScreenWidth() / Math.min(8.0, (double)pin.getBitSize());
            double bitHeight = (double)this.getScreenHeight() / ((double)((pin.getBitSize() - 1) / 8) + 1.0);
            int bitCol = (int)(x / bitWidth);
            int bitRow = (int)(y / bitHeight);
            int bit = pin.getBitSize() - 1 - (bitCol + bitRow * 8);
            if (bit >= 0 && bit < pin.getBitSize()) {
                WireValue newValue = new WireValue(value);
                newValue.setBit(bit, value.getBit(bit) == WireValue.State.ONE ? WireValue.State.ZERO : WireValue.State.ONE);
                pin.setValue(state, newValue);
            }
        }
    }

    @Override
    public boolean keyPressed(CircuitManager manager, CircuitState state, KeyCode keyCode, String text) {
        if (!this.isInput()) {
            return false;
        }
        switch (keyCode) {
            case NUMPAD0: 
            case NUMPAD1: 
            case DIGIT0: 
            case DIGIT1: {
                int value = text.charAt(0) - 48;
                WireValue currentValue = new WireValue(state.getLastPushed(((Pin)this.getComponent()).getPort(0)));
                for (int i = currentValue.getBitSize() - 1; i > 0; --i) {
                    currentValue.setBit(i, currentValue.getBit(i - 1));
                }
                currentValue.setBit(0, value == 1 ? WireValue.State.ONE : WireValue.State.ZERO);
                ((Pin)this.getComponent()).setValue(state, currentValue);
            }
        }
        return false;
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        WireValue value;
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFont(GuiUtils.getFont(16, true));
        Port port = ((Pin)this.getComponent()).getPort(0);
        WireValue wireValue = value = this.isInput() ? circuitState.getLastPushed(port) : circuitState.getLastReceived(port);
        if (circuitState.isShortCircuited(port.getLink())) {
            graphics.setFill((Paint)Color.RED);
        } else if (value.getBitSize() == 1) {
            GuiUtils.setBitColor(graphics, value.getBit(0));
        } else {
            graphics.setFill((Paint)Color.WHITE);
        }
        graphics.setStroke((Paint)Color.BLACK);
        if (this.isInput()) {
            GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
            GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        } else {
            graphics.fillRoundRect((double)this.getScreenX(), (double)this.getScreenY(), (double)this.getScreenWidth(), (double)this.getScreenHeight(), 20.0, 20.0);
            graphics.strokeRoundRect((double)this.getScreenX(), (double)this.getScreenY(), (double)this.getScreenWidth(), (double)this.getScreenHeight(), 20.0, 20.0);
        }
        graphics.setFill((Paint)(port.getLink().getBitSize() > 1 ? Color.BLACK : Color.WHITE));
        GuiUtils.drawValue(graphics, value.toString(), this.getScreenX(), this.getScreenY(), this.getScreenWidth());
    }
}

