/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.wiring;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.WireValue;
import com.ra4king.circuitsim.simulator.components.wiring.Constant;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class ConstantPeer
extends ComponentPeer<Constant> {
    private static final Properties.Property<Integer> VALUE = new Properties.Property<Integer>("Value", Properties.INTEGER_VALIDATOR, 0);
    private final WireValue value;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Constant"), new Image(ConstantPeer.class.getResourceAsStream("/resources/Constant.png")), new Properties());
    }

    public ConstantPeer(Properties props, int x, int y) {
        super(x, y, 0, 0);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(VALUE);
        properties.mergeIfExists(props);
        Constant constant = new Constant(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE), properties.getValue(VALUE));
        this.setWidth(Math.max(2, Math.min(8, constant.getBitSize())));
        this.setHeight((int)Math.round((double)(1 + (constant.getBitSize() - 1) / 8) * 1.5));
        this.value = WireValue.of(constant.getValue(), constant.getBitSize());
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: {
                connections.add(new Connection.PortConnection(this, constant.getPort(0), this.getWidth(), this.getHeight() / 2));
                break;
            }
            case WEST: {
                connections.add(new Connection.PortConnection(this, constant.getPort(0), 0, this.getHeight() / 2));
                break;
            }
            case NORTH: {
                connections.add(new Connection.PortConnection(this, constant.getPort(0), this.getWidth() / 2, 0));
                break;
            }
            case SOUTH: {
                connections.add(new Connection.PortConnection(this, constant.getPort(0), this.getWidth() / 2, this.getHeight()));
            }
        }
        this.init(constant, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFont(GuiUtils.getFont(16));
        graphics.setFill((Paint)Color.GRAY);
        graphics.setStroke((Paint)Color.GRAY);
        graphics.fillRoundRect((double)this.getScreenX(), (double)this.getScreenY(), (double)this.getScreenWidth(), (double)this.getScreenHeight(), 10.0, 10.0);
        graphics.strokeRoundRect((double)this.getScreenX(), (double)this.getScreenY(), (double)this.getScreenWidth(), (double)this.getScreenHeight(), 10.0, 10.0);
        if (this.value.getBitSize() > 1) {
            graphics.setFill((Paint)Color.BLACK);
        } else {
            GuiUtils.setBitColor(graphics, this.value.getBit(0));
        }
        GuiUtils.drawValue(graphics, this.value.toString(), this.getScreenX(), this.getScreenY(), this.getScreenWidth());
    }
}

