/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.wiring;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.components.wiring.Clock;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class ClockPeer
extends ComponentPeer<Clock> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Wiring", (Object)"Clock"), new Image(ClockPeer.class.getResourceAsStream("/resources/Clock.png")), new Properties());
    }

    public ClockPeer(Properties props, int x, int y) {
        super(x, y, 2, 2);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.mergeIfExists(props);
        Clock clock = new Clock(properties.getValue(Properties.LABEL));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: {
                connections.add(new Connection.PortConnection(this, clock.getPort(0), this.getWidth(), this.getHeight() / 2));
                break;
            }
            case WEST: {
                connections.add(new Connection.PortConnection(this, clock.getPort(0), 0, this.getHeight() / 2));
                break;
            }
            case NORTH: {
                connections.add(new Connection.PortConnection(this, clock.getPort(0), this.getWidth() / 2, 0));
                break;
            }
            case SOUTH: {
                connections.add(new Connection.PortConnection(this, clock.getPort(0), this.getWidth() / 2, this.getHeight()));
            }
        }
        this.init(clock, properties, connections);
    }

    @Override
    public void mousePressed(CircuitManager manager, CircuitState state, double x, double y) {
        Clock.tick(((Clock)this.getComponent()).getCircuit().getSimulator());
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        Port port = ((Clock)this.getComponent()).getPort(0);
        if (circuitState.isShortCircuited(port.getLink())) {
            graphics.setFill((Paint)Color.RED);
        } else {
            GuiUtils.setBitColor(graphics, circuitState.getLastPushed(port).getBit(0));
        }
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setStroke((Paint)Color.WHITE);
        graphics.setLineWidth(1.5);
        double offset1 = Clock.getTickState(((Clock)this.getComponent()).getCircuit().getSimulator()) ? 0.3 : 0.0;
        double offset2 = Clock.getTickState(((Clock)this.getComponent()).getCircuit().getSimulator()) ? 0.6 : 0.0;
        graphics.strokeLine((double)this.getScreenX() + (double)this.getScreenWidth() * (0.2 + offset1), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.7, (double)this.getScreenX() + (double)this.getScreenWidth() * (0.5 + offset1), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.7);
        graphics.strokeLine((double)this.getScreenX() + (double)this.getScreenWidth() * (0.5 - offset1), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.3, (double)this.getScreenX() + (double)this.getScreenWidth() * (0.8 - offset1), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.3);
        graphics.strokeLine((double)this.getScreenX() + (double)this.getScreenWidth() * (0.2 + offset2), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.5, (double)this.getScreenX() + (double)this.getScreenWidth() * (0.2 + offset2), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.7);
        graphics.strokeLine((double)this.getScreenX() + (double)this.getScreenWidth() * (0.8 - offset2), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.3, (double)this.getScreenX() + (double)this.getScreenWidth() * (0.8 - offset2), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.5);
        graphics.strokeLine((double)this.getScreenX() + (double)this.getScreenWidth() * 0.5, (double)this.getScreenY() + (double)this.getScreenHeight() * 0.3, (double)this.getScreenX() + (double)this.getScreenWidth() * 0.5, (double)this.getScreenY() + (double)this.getScreenHeight() * 0.7);
    }
}

