/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.plexers;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.plexers.PriorityEncoder;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class PriorityEncoderPeer
extends ComponentPeer<PriorityEncoder> {
    private static final byte ENABLED_INOUT_SIDE_LEN = 4;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Plexer", (Object)"Priority Encoder"), new Image(PriorityEncoderPeer.class.getResourceAsStream("/resources/PriorityEncoder.png")), new Properties());
    }

    public PriorityEncoderPeer(Properties props, int x, int y) {
        super(x, y, 4, 0);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(Properties.SELECTOR_BITS);
        properties.setValue(Properties.SELECTOR_BITS, 3);
        properties.mergeIfExists(props);
        PriorityEncoder pEncoder = new PriorityEncoder(properties.getValue(Properties.LABEL), properties.getValue(Properties.SELECTOR_BITS));
        int numInputs = 1 << pEncoder.getNumSelectBits();
        int inputSideLen = numInputs + 1;
        this.setHeight(inputSideLen);
        GuiUtils.rotateElementSize(this, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>(numInputs + 4);
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: {
                for (int i = 0; i < numInputs; ++i) {
                    connections.add(new Connection.PortConnection(this, pEncoder.getPort(i), String.valueOf(i), 0, i + 1));
                }
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledInPort(), "Enable In", 2, inputSideLen));
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledOutPort(), "Enable Out", 2, 0));
                connections.add(new Connection.PortConnection(this, pEncoder.getGroupSignalPort(), "Group Signal", 4, (inputSideLen >> 1) + 1));
                connections.add(new Connection.PortConnection(this, pEncoder.getOutputPort(), "Output", 4, inputSideLen >> 1));
                break;
            }
            case WEST: {
                for (int i = 0; i < numInputs; ++i) {
                    connections.add(new Connection.PortConnection(this, pEncoder.getPort(i), String.valueOf(i), 4, i + 1));
                }
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledInPort(), "Enable In", 2, inputSideLen));
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledOutPort(), "Enable Out", 2, 0));
                connections.add(new Connection.PortConnection(this, pEncoder.getGroupSignalPort(), "Group Signal", 0, (inputSideLen >> 1) + 1));
                connections.add(new Connection.PortConnection(this, pEncoder.getOutputPort(), "Output", 0, inputSideLen >> 1));
                break;
            }
            case SOUTH: {
                for (int i = 0; i < numInputs; ++i) {
                    connections.add(new Connection.PortConnection(this, pEncoder.getPort(i), String.valueOf(i), i + 1, 0));
                }
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledInPort(), "Enable In", 0, 2));
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledOutPort(), "Enable Out", inputSideLen, 2));
                connections.add(new Connection.PortConnection(this, pEncoder.getGroupSignalPort(), "Group Signal", inputSideLen >> 1, 4));
                connections.add(new Connection.PortConnection(this, pEncoder.getOutputPort(), "Output", (inputSideLen >> 1) + 1, 4));
                break;
            }
            case NORTH: {
                for (int i = 0; i < numInputs; ++i) {
                    connections.add(new Connection.PortConnection(this, pEncoder.getPort(i), String.valueOf(i), i + 1, 4));
                }
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledInPort(), "Enable In", inputSideLen, 2));
                connections.add(new Connection.PortConnection(this, pEncoder.getEnabledOutPort(), "Enable Out", 0, 2));
                connections.add(new Connection.PortConnection(this, pEncoder.getGroupSignalPort(), "Group Signal", (inputSideLen >> 1) + 1, 0));
                connections.add(new Connection.PortConnection(this, pEncoder.getOutputPort(), "Output", inputSideLen >> 1, 0));
                break;
            }
            default: {
                throw new RuntimeException("Unknown Direction");
            }
        }
        this.init(pEncoder, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        double zeroY;
        int width;
        int height;
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        Properties.Direction direction = this.getProperties().getValue(Properties.DIRECTION);
        graphics.translate((double)this.getScreenX(), (double)this.getScreenY());
        int inputSideLength = ((1 << ((PriorityEncoder)this.getComponent()).getNumSelectBits()) + 1) * 10;
        int enabledSideLength = 40;
        double zeroX = 5.0;
        if (direction == Properties.Direction.EAST || direction == Properties.Direction.WEST) {
            height = inputSideLength;
            width = enabledSideLength;
            zeroY = 15.0;
            if (direction == Properties.Direction.WEST) {
                zeroX = width - 10;
            }
        } else {
            height = enabledSideLength;
            width = inputSideLength;
            zeroY = height - 5;
            if (direction == Properties.Direction.SOUTH) {
                zeroY = 15.0;
            }
        }
        graphics.setStroke((Paint)Color.BLACK);
        graphics.strokeRect(0.0, 0.0, (double)width, (double)height);
        graphics.setFill((Paint)Color.WHITE);
        graphics.fillRect(0.0, 0.0, (double)width, (double)height);
        graphics.setFill((Paint)Color.DARKGRAY);
        graphics.fillText("0", zeroX, zeroY);
        graphics.setFill((Paint)Color.BLACK);
        graphics.fillText("Pri", (double)(width >> 1) - graphics.getFont().getSize(), (double)(height >> 1) + 5.0);
    }
}

