/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.plexers;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.plexers.Decoder;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class DecoderPeer
extends ComponentPeer<Decoder> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Plexer", (Object)"Decoder"), new Image(DecoderPeer.class.getResourceAsStream("/resources/Decoder.png")), new Properties());
    }

    public DecoderPeer(Properties props, int x, int y) {
        super(x, y, 3, 0);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(Properties.SELECTOR_LOCATION);
        properties.ensureProperty(Properties.SELECTOR_BITS);
        properties.mergeIfExists(props);
        Decoder decoder = new Decoder(properties.getValue(Properties.LABEL), properties.getValue(Properties.SELECTOR_BITS));
        this.setHeight(decoder.getNumOutputs() + 2);
        GuiUtils.rotateElementSize(this, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        boolean location = properties.getValue(Properties.SELECTOR_LOCATION);
        int outOffset = 0;
        int selOffset = 0;
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        switch (properties.getValue(Properties.DIRECTION)) {
            case EAST: {
                outOffset = this.getWidth();
                selOffset = 1;
            }
            case WEST: {
                for (int i = 0; i < decoder.getNumOutputs(); ++i) {
                    connections.add(new Connection.PortConnection(this, decoder.getPort(i), String.valueOf(i), outOffset, i + 1));
                }
                connections.add(new Connection.PortConnection(this, decoder.getSelectorPort(), "Selector", this.getWidth() / 2 + selOffset, location ? 0 : this.getHeight()));
                break;
            }
            case SOUTH: {
                outOffset = this.getHeight();
                selOffset = 1;
            }
            case NORTH: {
                for (int i = 0; i < decoder.getNumOutputs(); ++i) {
                    connections.add(new Connection.PortConnection(this, decoder.getPort(i), String.valueOf(i), i + 1, outOffset));
                }
                connections.add(new Connection.PortConnection(this, decoder.getSelectorPort(), "Selector", location ? 0 : this.getWidth(), this.getHeight() / 2 + selOffset));
            }
        }
        this.init(decoder, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        Properties.Direction direction = this.getProperties().getValue(Properties.DIRECTION);
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = 30;
        int height = (((Decoder)this.getComponent()).getNumOutputs() + 2) * 10;
        int zeroXOffset = 0;
        switch (direction) {
            case SOUTH: {
                graphics.translate((double)x, (double)y);
                graphics.rotate(270.0);
                graphics.translate((double)(-x - width), (double)(-y));
            }
            case WEST: {
                zeroXOffset = 2;
                graphics.beginPath();
                graphics.moveTo((double)x, (double)y);
                graphics.lineTo((double)(x + width), (double)y + Math.min(20.0, (double)height * 0.2));
                graphics.lineTo((double)(x + width), (double)(y + height) - Math.min(20.0, (double)height * 0.2));
                graphics.lineTo((double)x, (double)(y + height));
                graphics.closePath();
                break;
            }
            case NORTH: {
                graphics.translate((double)x, (double)y);
                graphics.rotate(270.0);
                graphics.translate((double)(-x - width), (double)(-y));
            }
            case EAST: {
                zeroXOffset = width - 10;
                graphics.beginPath();
                graphics.moveTo((double)(x + width), (double)y);
                graphics.lineTo((double)x, (double)y + Math.min(20.0, (double)height * 0.2));
                graphics.lineTo((double)x, (double)(y + height) - Math.min(20.0, (double)height * 0.2));
                graphics.lineTo((double)(x + width), (double)(y + height));
                graphics.closePath();
            }
        }
        graphics.setFill((Paint)Color.WHITE);
        graphics.fill();
        graphics.setStroke((Paint)Color.BLACK);
        graphics.stroke();
        graphics.setFill((Paint)Color.DARKGRAY);
        graphics.fillText("0", (double)(x + zeroXOffset), (double)(y + 13));
    }
}

