/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.misc;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Scene;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class Text
extends ComponentPeer<Component> {
    private static Image textImage;
    private static final Properties.Property<String> TEXT;
    private String text;
    private List<String> lines;
    private Cursor prevCursor;
    private boolean entered;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        textImage = new Image(Text.class.getResourceAsStream("/resources/Text.png"));
        manager.addComponent((Pair<String, String>)new Pair((Object)"Misc", (Object)"Text"), textImage, new Properties());
    }

    public Text(Properties props, int x, int y) {
        super(x, y, 2, 2);
        Properties properties = new Properties();
        properties.ensureProperty(TEXT);
        properties.mergeIfExists(props);
        this.setText(properties.getValue(TEXT));
        Component component = new Component(this.text, new int[0]){

            @Override
            public void valueChanged(CircuitState state, WireValue value, int portIndex) {
            }
        };
        this.init(component, properties, new ArrayList<Connection.PortConnection>());
    }

    private void setText(String text) {
        this.text = text;
        this.lines = Arrays.asList(text.split("\n", -1));
        Bounds bounds = GuiUtils.getBounds(GuiUtils.getFont(13), text, false);
        this.setWidth(Math.max(2, (int)Math.ceil(bounds.getWidth() / 10.0)));
        this.setHeight(Math.max(2, (int)Math.ceil(bounds.getHeight() / 10.0)));
    }

    @Override
    public void mouseEntered(CircuitManager manager, CircuitState state) {
        Scene scene = manager.getSimulatorWindow().getScene();
        this.prevCursor = scene.getCursor();
        scene.setCursor(Cursor.TEXT);
        this.entered = true;
    }

    @Override
    public void mouseExited(CircuitManager manager, CircuitState state) {
        manager.getSimulatorWindow().getScene().setCursor(this.prevCursor);
        this.entered = false;
    }

    @Override
    public boolean keyPressed(CircuitManager manager, CircuitState state, KeyCode keyCode, String text) {
        return keyCode == KeyCode.BACK_SPACE && !this.text.isEmpty();
    }

    @Override
    public void keyTyped(CircuitManager manager, CircuitState state, String character) {
        char c = character.charAt(0);
        if (c == '\b') {
            if (!this.text.isEmpty()) {
                String s = this.text.substring(0, this.text.length() - 1);
                this.setText(s);
                this.getProperties().setValue(TEXT, s);
            }
        } else if (c == '\n' || c == '\r' || c >= ' ' && c <= '~') {
            if (c == '\r') {
                c = '\n';
            }
            String s = this.text + c;
            this.setText(s);
            this.getProperties().setValue(TEXT, s);
        }
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState state) {
        graphics.setFill((Paint)Color.BLACK);
        graphics.setStroke((Paint)Color.BLACK);
        graphics.setLineWidth(2.0);
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        if (this.text.isEmpty()) {
            graphics.drawImage(textImage, (double)x, (double)y, (double)width, (double)height);
        } else {
            graphics.setFont(GuiUtils.getFont(13));
            for (int i = 0; i < this.lines.size(); ++i) {
                String line = this.lines.get(i);
                Bounds bounds = GuiUtils.getBounds(graphics.getFont(), line, false);
                graphics.fillText(line, (double)x + ((double)width - bounds.getWidth()) * 0.5, (double)(y + 15 * (i + 1)));
                if (!this.entered || i != this.lines.size() - 1) continue;
                double lx = (double)x + ((double)width + bounds.getWidth()) * 0.5 + 3.0;
                double ly = y + 15 * (i + 1);
                graphics.strokeLine(lx, ly - 10.0, lx, ly);
            }
        }
    }

    static {
        TEXT = new Properties.Property<String>("Text", Properties.ANY_STRING_VALIDATOR, "");
    }
}

