/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.memory;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.WireValue;
import com.ra4king.circuitsim.simulator.components.memory.Register;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class RegisterPeer
extends ComponentPeer<Register> {
    private final Connection.PortConnection clockConnection;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Memory", (Object)"Register"), new Image(RegisterPeer.class.getResourceAsStream("/resources/Register.png")), new Properties());
    }

    public RegisterPeer(Properties props, int x, int y) {
        super(x, y, 4, 4);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.mergeIfExists(props);
        Register register = new Register(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, register.getPort(0), "In", 0, 2));
        connections.add(new Connection.PortConnection(this, register.getPort(1), "Enable", 0, 3));
        this.clockConnection = new Connection.PortConnection(this, register.getPort(2), "Clock", 1, this.getHeight());
        connections.add(this.clockConnection);
        connections.add(new Connection.PortConnection(this, register.getPort(3), "Clear", 3, this.getHeight()));
        connections.add(new Connection.PortConnection(this, register.getPort(4), "Out", this.getWidth(), 2));
        this.init(register, properties, connections);
    }

    @Override
    public boolean keyPressed(CircuitManager manager, CircuitState state, KeyCode keyCode, String text) {
        switch (keyCode) {
            case DIGIT0: 
            case DIGIT1: 
            case DIGIT2: 
            case DIGIT3: 
            case DIGIT4: 
            case DIGIT5: 
            case DIGIT6: 
            case DIGIT7: 
            case DIGIT8: 
            case DIGIT9: 
            case NUMPAD0: 
            case NUMPAD1: 
            case NUMPAD2: 
            case NUMPAD3: 
            case NUMPAD4: 
            case NUMPAD5: 
            case NUMPAD6: 
            case NUMPAD7: 
            case NUMPAD8: 
            case NUMPAD9: 
            case A: 
            case B: 
            case C: 
            case D: 
            case E: 
            case F: {
                char c = text.charAt(0);
                int value = c >= '0' && c <= '9' ? c - 48 : Character.toUpperCase(c) - 65 + 10;
                WireValue currentValue = state.getLastPushed(((Register)this.getComponent()).getPort(4));
                WireValue typedValue = WireValue.of(value, Math.min(4, currentValue.getBitSize()));
                if (typedValue.getValue() != value) {
                    typedValue.setAllBits(WireValue.State.ZERO);
                }
                if (currentValue.getBitSize() <= 4) {
                    currentValue.set(typedValue);
                } else {
                    int i;
                    for (i = currentValue.getBitSize() - 1; i >= 4; --i) {
                        currentValue.setBit(i, currentValue.getBit(i - 4));
                    }
                    for (i = 0; i < 4; ++i) {
                        currentValue.setBit(i, typedValue.getBit(i));
                    }
                }
                state.pushValue(((Register)this.getComponent()).getPort(4), currentValue);
            }
        }
        return false;
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        String value = circuitState.getLastPushed(((Register)this.getComponent()).getPort(4)).toHexString();
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        graphics.setFill((Paint)Color.BLACK);
        graphics.setFont(GuiUtils.getFont(13));
        int i = 0;
        while (i * 4 < value.length()) {
            int endIndex = i * 4 + 4 > value.length() ? value.length() : 4 * i + 4;
            String toPrint = value.substring(4 * i, endIndex);
            Bounds bounds = GuiUtils.getBounds(graphics.getFont(), toPrint, false);
            graphics.fillText(toPrint, (double)x + (double)width * 0.5 - bounds.getWidth() * 0.5, (double)(y + 11 + 10 * i));
            ++i;
        }
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setFill((Paint)Color.GRAY);
        graphics.setFont(GuiUtils.getFont(10));
        graphics.fillText("D", (double)(x + 3), (double)y + (double)height * 0.5 + 6.0);
        graphics.fillText("Q", (double)(x + width - 10), (double)y + (double)height * 0.5 + 6.0);
        graphics.fillText("en", (double)(x + 3), (double)(y + height - 7));
        graphics.fillText("0", (double)(x + width - 13), (double)(y + height - 4));
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawClockInput(graphics, this.clockConnection, Properties.Direction.SOUTH);
    }
}

