/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.memory;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.memory.ROM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class ROMPeer
extends ComponentPeer<ROM> {
    private final Properties.Property<List<Properties.MemoryLine>> contentsProperty;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Memory", (Object)"ROM"), new Image(ROMPeer.class.getResourceAsStream("/resources/ROM.png")), new Properties());
    }

    public ROMPeer(Properties props, int x, int y) {
        super(x, y, 9, 5);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(Properties.ADDRESS_BITS);
        properties.mergeIfExists(props);
        int addressBits = properties.getValue(Properties.ADDRESS_BITS);
        int dataBits = properties.getValue(Properties.BITSIZE);
        this.contentsProperty = new Properties.Property<Object>("Contents", new Properties.PropertyMemoryValidator(addressBits, dataBits), null);
        Properties.Property oldContents = props.getProperty("Contents");
        String oldMemory = oldContents == null ? "" : (oldContents.validator == null ? (String)props.getValue("Contents") : oldContents.getStringValue());
        properties.setValue(this.contentsProperty, this.contentsProperty.validator.parse(oldMemory));
        int[] memory = ROMPeer.memoryToArray(properties.getValue(this.contentsProperty));
        ROM ram = new ROM(properties.getValue(Properties.LABEL), dataBits, addressBits, memory);
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, ram.getPort(0), "Address", 0, 2));
        connections.add(new Connection.PortConnection(this, ram.getPort(1), "Enable", 4, this.getHeight()));
        connections.add(new Connection.PortConnection(this, ram.getPort(2), "Data", this.getWidth(), 2));
        this.init(ram, properties, connections);
    }

    private static int[] memoryToArray(List<Properties.MemoryLine> lines) {
        if (lines == null) {
            return new int[0];
        }
        return lines.stream().flatMap(line -> line.values.stream()).mapToInt(prop -> Integer.parseUnsignedInt((String)prop.get(), 16)).toArray();
    }

    @Override
    public List<MenuItem> getContextMenuItems(CircuitManager circuit) {
        MenuItem menuItem = new MenuItem("Edit contents");
        menuItem.setOnAction(event -> {
            Properties.Property property = this.getProperties().getProperty(this.contentsProperty.name);
            Properties.PropertyMemoryValidator memoryValidator = (Properties.PropertyMemoryValidator)property.validator;
            ArrayList<Properties.MemoryLine> lines = new ArrayList<Properties.MemoryLine>();
            circuit.getSimulatorWindow().getSimulator().runSync(() -> {
                int[] memory = ((ROM)this.getComponent()).getMemory();
                lines.addAll(memoryValidator.parse(memory, (address, value) -> {
                    memory[address.intValue()] = value;
                    int index = address / 16;
                    Properties.MemoryLine line = (Properties.MemoryLine)((List)property.value).get(index);
                    line.values.get(address - index * 16).setValue(memoryValidator.parseValue((int)value));
                    circuit.getCircuit().forEachState(state -> ((ROM)this.getComponent()).valueChanged((CircuitState)state, null, 0));
                }));
            });
            memoryValidator.createAndShowMemoryWindow(circuit.getSimulatorWindow().getStage(), lines);
        });
        return Collections.singletonList(menuItem);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        String address = circuitState.getLastReceived(((ROM)this.getComponent()).getPort(0)).toHexString();
        String value = circuitState.getLastPushed(((ROM)this.getComponent()).getPort(2)).toHexString();
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        graphics.setFont(GuiUtils.getFont(11, true));
        String text = "ROM";
        Bounds bounds = GuiUtils.getBounds(graphics.getFont(), text);
        graphics.setFill((Paint)Color.BLACK);
        graphics.fillText(text, (double)x + ((double)width - bounds.getWidth()) * 0.5, (double)y + ((double)height + bounds.getHeight()) * 0.2);
        text = "A: " + address;
        double addrY = (double)y + bounds.getHeight() + 12.0;
        graphics.fillText(text, (double)(x + 13), addrY);
        bounds = GuiUtils.getBounds(graphics.getFont(), text);
        graphics.fillText("D: " + value, (double)(x + 13), addrY + bounds.getHeight());
        graphics.setFill((Paint)Color.GRAY);
        graphics.setFont(GuiUtils.getFont(10));
        graphics.fillText("A", (double)(x + 3), (double)y + (double)height * 0.5 - 1.0);
        graphics.fillText("D", (double)(x + width - 9), (double)y + (double)height * 0.5 - 1.0);
        graphics.fillText("en", (double)x + (double)width * 0.5 - 11.5, (double)(y + height) - 3.5);
    }
}

