/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.memory;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.WireValue;
import com.ra4king.circuitsim.simulator.components.memory.RAM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class RAMPeer
extends ComponentPeer<RAM> {
    private final Connection.PortConnection clockConnection;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Memory", (Object)"RAM"), new Image(RAMPeer.class.getResourceAsStream("/resources/RAM.png")), new Properties());
    }

    public RAMPeer(Properties props, int x, int y) {
        super(x, y, 9, 5);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(Properties.ADDRESS_BITS);
        properties.mergeIfExists(props);
        int addressBits = properties.getValue(Properties.ADDRESS_BITS);
        int dataBits = properties.getValue(Properties.BITSIZE);
        RAM ram = new RAM(properties.getValue(Properties.LABEL), dataBits, addressBits);
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, ram.getPort(0), "Address", 0, 2));
        this.clockConnection = new Connection.PortConnection(this, ram.getPort(2), "Clock", 3, this.getHeight());
        connections.add(this.clockConnection);
        connections.add(new Connection.PortConnection(this, ram.getPort(1), "Enable", 4, this.getHeight()));
        connections.add(new Connection.PortConnection(this, ram.getPort(3), "Load", 5, this.getHeight()));
        connections.add(new Connection.PortConnection(this, ram.getPort(4), "Clear", 6, this.getHeight()));
        connections.add(new Connection.PortConnection(this, ram.getPort(5), "Data", this.getWidth(), 2));
        this.init(ram, properties, connections);
    }

    @Override
    public List<MenuItem> getContextMenuItems(CircuitManager circuit) {
        MenuItem menuItem = new MenuItem("Edit contents");
        menuItem.setOnAction(event -> {
            Properties.PropertyMemoryValidator memoryValidator = new Properties.PropertyMemoryValidator(((RAM)this.getComponent()).getAddressBits(), ((RAM)this.getComponent()).getDataBits());
            ArrayList<Properties.MemoryLine> memory = new ArrayList<Properties.MemoryLine>();
            BiConsumer<Integer, Integer> listener = (address, data) -> {
                int index = address / 16;
                Properties.MemoryLine line = (Properties.MemoryLine)memory.get(index);
                line.values.get(address - index * 16).setValue(memoryValidator.parseValue((int)data));
            };
            circuit.getSimulatorWindow().getSimulator().runSync(() -> {
                CircuitState currentState = circuit.getCircuitBoard().getCurrentState();
                memory.addAll(memoryValidator.parse(((RAM)this.getComponent()).getMemoryContents(currentState), (address, value) -> ((RAM)this.getComponent()).store(currentState, (int)address, (int)value)));
                ((RAM)this.getComponent()).addMemoryListener(listener);
            });
            memoryValidator.createAndShowMemoryWindow(circuit.getSimulatorWindow().getStage(), memory);
            ((RAM)this.getComponent()).removeMemoryListener(listener);
        });
        return Collections.singletonList(menuItem);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        WireValue valueVal;
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawClockInput(graphics, this.clockConnection, Properties.Direction.SOUTH);
        WireValue addressVal = circuitState.getLastReceived(((RAM)this.getComponent()).getPort(0));
        if (addressVal.isValidValue()) {
            int val = ((RAM)this.getComponent()).load(circuitState, addressVal.getValue());
            valueVal = WireValue.of(val, ((RAM)this.getComponent()).getDataBits());
        } else {
            valueVal = new WireValue(((RAM)this.getComponent()).getDataBits());
        }
        String address = addressVal.toHexString();
        String value = valueVal.toHexString();
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        graphics.setFont(GuiUtils.getFont(11, true));
        String text = "RAM";
        Bounds bounds = GuiUtils.getBounds(graphics.getFont(), text);
        graphics.setFill((Paint)Color.BLACK);
        graphics.fillText(text, (double)x + ((double)width - bounds.getWidth()) * 0.5, (double)y + ((double)height + bounds.getHeight()) * 0.2);
        text = "A: " + address;
        double addrY = (double)y + bounds.getHeight() + 12.0;
        graphics.fillText(text, (double)(x + 13), addrY);
        bounds = GuiUtils.getBounds(graphics.getFont(), text);
        graphics.fillText("D: " + value, (double)(x + 13), addrY + bounds.getHeight());
        graphics.setFill((Paint)Color.GRAY);
        graphics.setFont(GuiUtils.getFont(10));
        graphics.fillText("A", (double)(x + 3), (double)y + (double)height * 0.5 - 1.0);
        graphics.fillText("D", (double)(x + width - 9), (double)y + (double)height * 0.5 - 1.0);
        graphics.fillText("en", (double)x + (double)width * 0.5 - 11.5, (double)(y + height) - 3.5);
        graphics.fillText("L", (double)x + (double)width * 0.5 + 2.0, (double)(y + height) - 3.5);
        graphics.fillText("0", (double)x + (double)width * 0.5 + 11.5, (double)(y + height) - 3.5);
    }
}

