/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.memory;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.WireValue;
import com.ra4king.circuitsim.simulator.components.memory.DFlipFlop;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class DFlipFlopPeer
extends ComponentPeer<DFlipFlop> {
    private final Connection.PortConnection clockConnection;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Memory", (Object)"D Flip-Flop"), new Image(DFlipFlopPeer.class.getResourceAsStream("/resources/DFlipFlop.png")), new Properties());
    }

    public DFlipFlopPeer(Properties props, int x, int y) {
        super(x, y, 4, 4);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.mergeIfExists(props);
        DFlipFlop flipFlop = new DFlipFlop(properties.getValue(Properties.LABEL));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        this.clockConnection = new Connection.PortConnection(this, flipFlop.getPort(1), "Clock", 0, 1);
        connections.add(this.clockConnection);
        connections.add(new Connection.PortConnection(this, flipFlop.getPort(0), "Data input", 0, 3));
        connections.add(new Connection.PortConnection(this, flipFlop.getPort(3), "Preset", 1, 4));
        connections.add(new Connection.PortConnection(this, flipFlop.getPort(2), "Enable", 2, 4));
        connections.add(new Connection.PortConnection(this, flipFlop.getPort(4), "Clear", 3, 4));
        connections.add(new Connection.PortConnection(this, flipFlop.getPort(5), "Current state", 4, 1));
        connections.add(new Connection.PortConnection(this, flipFlop.getPort(6), "NOT of current state", 4, 3));
        this.init(flipFlop, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState state) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        WireValue.State bit = state.getLastPushed(((DFlipFlop)this.getComponent()).getPort(5)).getBit(0);
        GuiUtils.setBitColor(graphics, bit);
        graphics.fillOval((double)x + (double)width * 0.5 - 10.0, (double)y + (double)height * 0.5 - 10.0, 20.0, 20.0);
        graphics.setFill((Paint)Color.WHITE);
        graphics.setFont(GuiUtils.getFont(16));
        graphics.fillText(String.valueOf(bit.repr), (double)x + (double)width * 0.5 - 5.0, (double)y + (double)height * 0.5 + 6.0);
        graphics.setFill((Paint)Color.GRAY);
        graphics.setFont(GuiUtils.getFont(10));
        graphics.fillText("D", (double)(x + 3), (double)(y + height - 7));
        graphics.fillText("Q", (double)(x + width - 10), (double)(y + 13));
        graphics.fillText("1", (double)(x + 7), (double)(y + height - 4));
        graphics.fillText("en", (double)x + (double)width * 0.5 - 6.0, (double)(y + height - 4));
        graphics.fillText("0", (double)(x + width - 13), (double)(y + height - 4));
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawClockInput(graphics, this.clockConnection, Properties.Direction.WEST);
    }
}

