/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.io;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class LEDMatrix
extends ComponentPeer<Component> {
    private static final Properties.Property<Integer> COL_COUNT = new Properties.Property<Integer>("Column count", Properties.BITSIZE.validator, 5);
    private static final Properties.Property<Integer> ROW_COUNT = new Properties.Property<Integer>("Row count", Properties.BITSIZE.validator, 7);

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Input/Output", (Object)"LED Matrix"), new Image(LEDMatrix.class.getResourceAsStream("/resources/LEDMatrix.png")), new Properties());
    }

    public LEDMatrix(Properties props, int x, int y) {
        super(x, y, 0, 0);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(COL_COUNT);
        properties.ensureProperty(ROW_COUNT);
        properties.mergeIfExists(props);
        int rows = properties.getValue(ROW_COUNT);
        int cols = properties.getValue(COL_COUNT);
        this.setWidth(cols);
        this.setHeight(rows);
        int[] bitsizes = new int[rows];
        Arrays.fill(bitsizes, cols);
        Component component = new Component(properties.getValue(Properties.LABEL), bitsizes){

            @Override
            public void valueChanged(CircuitState state, WireValue value, int portIndex) {
            }
        };
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        for (int i = 0; i < rows; ++i) {
            connections.add(new Connection.PortConnection(this, component.getPort(i), 0, i));
        }
        this.init(component, properties, connections);
    }

    @Override
    public int getScreenY() {
        return (int)((double)super.getScreenY() - 5.0);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        for (int i = 0; i < ((Component)this.getComponent()).getNumPorts(); ++i) {
            WireValue value = circuitState.getLastReceived(((Component)this.getComponent()).getPort(i));
            for (int b = value.getBitSize() - 1; b >= 0; --b) {
                GuiUtils.setBitColor(graphics, value.getBit(b));
                graphics.fillRect((double)(this.getScreenX() + (value.getBitSize() - b - 1) * 10), (double)(this.getScreenY() + i * 10), 10.0, 10.0);
            }
        }
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
    }
}

