/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.io;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class LED
extends ComponentPeer<Component> {
    private static final Properties.Property<Color> ON_COLOR_PROPERTY;
    private static final Properties.Property<Color> OFF_COLOR_PROPERTY;
    private final Color offColor;
    private final Color onColor;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Input/Output", (Object)"LED"), new Image(LED.class.getResourceAsStream("/resources/LED.png")), new Properties());
    }

    public LED(Properties props, int x, int y) {
        super(x, y, 2, 2);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(OFF_COLOR_PROPERTY);
        properties.ensureProperty(ON_COLOR_PROPERTY);
        properties.mergeIfExists(props);
        this.offColor = properties.getValue(OFF_COLOR_PROPERTY);
        this.onColor = properties.getValue(ON_COLOR_PROPERTY);
        Component component = new Component(properties.getValue(Properties.LABEL), new int[]{1}){

            @Override
            public void valueChanged(CircuitState state, WireValue value, int portIndex) {
            }
        };
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, component.getPort(0), 0, 1));
        GuiUtils.rotatePorts(connections, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        this.init(component, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState state) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        WireValue.State bit = state.getLastReceived(((Component)this.getComponent()).getPort(0)).getBit(0);
        graphics.setFill((Paint)(bit == WireValue.State.ONE ? this.onColor : this.offColor));
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillOval(arg_0, arg_1, arg_2, arg_3), this);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeOval(arg_0, arg_1, arg_2, arg_3), this);
    }

    static {
        OFF_COLOR_PROPERTY = new Properties.Property<Color>("Off Color", Properties.COLOR_VALIDATOR, Color.DARKGRAY);
        ON_COLOR_PROPERTY = new Properties.Property<Color>("On Color", Properties.COLOR_VALIDATOR, Color.RED);
    }
}

