/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.io;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class HexDisplay
extends ComponentPeer<Component> {
    private static final Set<Integer> top = new HashSet<Integer>(Arrays.asList(0, 2, 3, 5, 6, 7, 8, 9, 10, 12, 14, 15));
    private static final Set<Integer> topRight = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 7, 8, 9, 10, 13));
    private static final Set<Integer> botRight = new HashSet<Integer>(Arrays.asList(0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13));
    private static final Set<Integer> bottom = new HashSet<Integer>(Arrays.asList(0, 2, 3, 5, 6, 8, 9, 11, 12, 13, 14));
    private static final Set<Integer> botLeft = new HashSet<Integer>(Arrays.asList(0, 2, 6, 8, 10, 11, 12, 13, 14, 15));
    private static final Set<Integer> topLeft = new HashSet<Integer>(Arrays.asList(0, 4, 5, 6, 8, 9, 10, 11, 12, 14, 15));
    private static final Set<Integer> middle = new HashSet<Integer>(Arrays.asList(2, 3, 4, 5, 6, 8, 9, 10, 11, 13, 14, 15));

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Input/Output", (Object)"Hex Display"), new Image(HexDisplay.class.getResourceAsStream("/resources/HexDisplay.png")), new Properties());
    }

    public HexDisplay(Properties props, int x, int y) {
        super(x, y, 4, 6);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.mergeIfExists(props);
        Component component = new Component(properties.getValue(Properties.LABEL), new int[]{4}){

            @Override
            public void valueChanged(CircuitState state, WireValue value, int portIndex) {
            }
        };
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, component.getPort(0), this.getWidth() / 2, this.getHeight()));
        this.init(component, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        this.drawDigit(graphics, -1);
        WireValue value = circuitState.getLastReceived(((Component)this.getComponent()).getPort(0));
        if (value.isValidValue()) {
            this.drawDigit(graphics, value.getValue());
        }
    }

    private void drawDigit(GraphicsContext graphics, int num) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        int margin = 4;
        int size = 6;
        if (top.contains(num)) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.fillRect((double)(x + margin + size), (double)(y + margin), (double)(width - 2 * margin - 2 * size), (double)size);
        if (middle.contains(num)) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.fillRect((double)(x + margin + size), (double)(y + (height - size) / 2), (double)(width - 2 * margin - 2 * size), (double)size);
        if (bottom.contains(num)) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.fillRect((double)(x + margin + size), (double)(y + height - margin - size), (double)(width - 2 * margin - 2 * size), (double)size);
        if (topRight.contains(num)) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.fillRect((double)(x + width - margin - size), (double)(y + margin + size / 2), (double)size, (double)((height - size) / 2 - margin));
        if (topLeft.contains(num)) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.fillRect((double)(x + margin), (double)(y + margin + size / 2), (double)size, (double)((height - size) / 2 - margin));
        if (botRight.contains(num)) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.fillRect((double)(x + width - margin - size), (double)(y + height / 2), (double)size, (double)((height - size) / 2 - margin));
        if (botLeft.contains(num)) {
            graphics.setFill((Paint)Color.RED);
        } else {
            graphics.setFill((Paint)Color.LIGHTGRAY);
        }
        graphics.fillRect((double)(x + margin), (double)(y + height / 2), (double)size, (double)((height - size) / 2 - margin));
    }
}

