/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.io;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.WireValue;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class Button
extends ComponentPeer<Component> {
    private boolean isPressed = false;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Input/Output", (Object)"Button"), new Image(Button.class.getResourceAsStream("/resources/Button.png")), new Properties());
    }

    public Button(Properties props, int x, int y) {
        super(x, y, 2, 2);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        properties.mergeIfExists(props);
        Component component = new Component(properties.getValue(Properties.LABEL), new int[]{1}){

            @Override
            public void init(CircuitState state, Object lastProperty) {
                state.pushValue(this.getPort(0), WireValue.of(0L, 1));
            }

            @Override
            public void valueChanged(CircuitState state, WireValue value, int portIndex) {
            }
        };
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, component.getPort(0), this.getWidth(), this.getHeight() / 2));
        GuiUtils.rotatePorts(connections, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        this.init(component, properties, connections);
    }

    @Override
    public void mousePressed(CircuitManager manager, CircuitState state, double x, double y) {
        this.isPressed = true;
        state.pushValue(((Component)this.getComponent()).getPort(0), WireValue.of(1L, 1));
    }

    @Override
    public void mouseReleased(CircuitManager manager, CircuitState state, double x, double y) {
        this.isPressed = false;
        state.pushValue(((Component)this.getComponent()).getPort(0), WireValue.of(0L, 1));
    }

    @Override
    public boolean keyPressed(CircuitManager manager, CircuitState state, KeyCode keyCode, String text) {
        if (keyCode == KeyCode.SPACE) {
            this.mousePressed(manager, state, 0.0, 0.0);
        }
        return false;
    }

    @Override
    public void keyReleased(CircuitManager manager, CircuitState state, KeyCode keyCode, String text) {
        if (keyCode == KeyCode.SPACE) {
            this.mouseReleased(manager, state, 0.0, 0.0);
        }
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState state) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        int offset = 3;
        graphics.setStroke((Paint)Color.BLACK);
        if (this.isPressed) {
            graphics.setFill((Paint)Color.WHITE);
        } else {
            graphics.setFill((Paint)Color.DARKGRAY);
        }
        graphics.fillRect((double)(x + offset), (double)(y + offset), (double)(width - offset), (double)(height - offset));
        graphics.strokeRect((double)(x + offset), (double)(y + offset), (double)(width - offset), (double)(height - offset));
        if (!this.isPressed) {
            graphics.setFill((Paint)Color.WHITE);
            graphics.fillRect((double)x, (double)y, (double)(width - offset), (double)(height - offset));
            graphics.strokeRect((double)x, (double)y, (double)(width - offset), (double)(height - offset));
            graphics.strokeLine((double)x, (double)(y + height - offset), (double)(x + offset), (double)(y + height));
            graphics.strokeLine((double)(x + width - offset), (double)y, (double)(x + width), (double)(y + offset));
            graphics.strokeLine((double)(x + width - offset), (double)(y + height - offset), (double)(x + width), (double)(y + height));
        }
    }
}

