/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.gates;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.gates.GatePeer;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.gates.XnorGate;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.util.Pair;

public class XnorGatePeer
extends GatePeer<XnorGate> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Gates", (Object)"XNOR"), new Image(XnorGatePeer.class.getResourceAsStream("/resources/XnorGate.png")), new Properties());
    }

    public XnorGatePeer(Properties properties, int x, int y) {
        super(properties, x, y);
    }

    @Override
    protected void ensureProperties(Properties properties) {
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(Properties.NUM_INPUTS);
    }

    @Override
    public XnorGate buildGate(Properties properties) {
        int numInputs = properties.getValue(Properties.NUM_INPUTS);
        return new XnorGate(properties.getValue(Properties.LABEL), (int)properties.getValue(Properties.BITSIZE), numInputs, XnorGatePeer.parseNegatedInputs(numInputs, properties));
    }

    @Override
    public void paintGate(GraphicsContext graphics, CircuitState circuitState) {
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = 40;
        int height = 40;
        graphics.beginPath();
        graphics.moveTo((double)x + (double)width * 0.1, (double)(y + height));
        graphics.arc((double)x + (double)width * 0.1, (double)y + (double)height * 0.5, (double)width * 0.25, (double)height * 0.5, 270.0, 180.0);
        graphics.arcTo((double)x + (double)width * 0.66, (double)y, (double)(x + width), (double)y + (double)height * 1.3, (double)width * 0.7);
        graphics.arcTo((double)x + (double)width * 0.66, (double)(y + height), (double)x + (double)width * 0.1, (double)(y + height), (double)width * 0.7);
        graphics.closePath();
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        graphics.fill();
        graphics.stroke();
        graphics.strokeArc((double)x - (double)width * 0.3, (double)y, (double)width * 0.5, (double)height, 270.0, 180.0, ArcType.OPEN);
        graphics.fillOval((double)x + (double)width * 0.8, (double)y + (double)height * 0.5 - (double)width * 0.1, (double)width * 0.2, (double)width * 0.2);
        graphics.strokeOval((double)x + (double)width * 0.8, (double)y + (double)height * 0.5 - (double)width * 0.1, (double)width * 0.2, (double)width * 0.2);
    }
}

