/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.gates;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.gates.GatePeer;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.gates.OrGate;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class OrGatePeer
extends GatePeer<OrGate> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Gates", (Object)"OR"), new Image(OrGatePeer.class.getResourceAsStream("/resources/OrGate.png")), new Properties());
    }

    public OrGatePeer(Properties properties, int x, int y) {
        super(properties, x, y);
    }

    @Override
    protected void ensureProperties(Properties properties) {
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(Properties.NUM_INPUTS);
    }

    @Override
    public OrGate buildGate(Properties properties) {
        int numInputs = properties.getValue(Properties.NUM_INPUTS);
        return new OrGate(properties.getValue(Properties.LABEL), (int)properties.getValue(Properties.BITSIZE), numInputs, OrGatePeer.parseNegatedInputs(numInputs, properties));
    }

    @Override
    public void paintGate(GraphicsContext graphics, CircuitState circuitState) {
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = 40;
        int height = 40;
        graphics.beginPath();
        graphics.moveTo((double)x, (double)(y + height));
        graphics.arc((double)x, (double)y + (double)height * 0.5, (double)width * 0.25, (double)height * 0.5, 270.0, 180.0);
        graphics.arcTo((double)x + (double)width * 0.66, (double)y, (double)x + (double)width * 1.25, (double)(y + height), (double)width);
        graphics.arcTo((double)x + (double)width * 0.66, (double)(y + height), (double)x, (double)(y + height), (double)width);
        graphics.closePath();
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        graphics.fill();
        graphics.stroke();
    }
}

