/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.gates;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.gates.GatePeer;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.gates.NotGate;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class NotGatePeer
extends GatePeer<NotGate> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Gates", (Object)"NOT"), new Image(NotGatePeer.class.getResourceAsStream("/resources/NotGate.png")), new Properties());
    }

    public NotGatePeer(Properties properties, int x, int y) {
        super(properties, x, y, 3, 2);
    }

    @Override
    protected void ensureProperties(Properties properties) {
        properties.ensureProperty(Properties.BITSIZE);
    }

    @Override
    public NotGate buildGate(Properties properties) {
        return new NotGate(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE));
    }

    @Override
    public void paintGate(GraphicsContext graphics, CircuitState circuitState) {
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = 30;
        int height = 20;
        graphics.beginPath();
        graphics.moveTo((double)x, (double)y);
        graphics.lineTo((double)x, (double)(y + height));
        graphics.lineTo((double)x + (double)width * 0.7, (double)y + (double)height * 0.5);
        graphics.closePath();
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        graphics.fill();
        graphics.stroke();
        graphics.fillOval((double)x + (double)width * 0.7, (double)y + (double)height * 0.5 - (double)width * 0.125, (double)width * 0.25, (double)width * 0.25);
        graphics.strokeOval((double)x + (double)width * 0.7, (double)y + (double)height * 0.5 - (double)width * 0.125, (double)width * 0.25, (double)width * 0.25);
    }
}

