/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.gates;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.gates.GatePeer;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.gates.NorGate;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class NorGatePeer
extends GatePeer<NorGate> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Gates", (Object)"NOR"), new Image(NorGatePeer.class.getResourceAsStream("/resources/NorGate.png")), new Properties());
    }

    public NorGatePeer(Properties properties, int x, int y) {
        super(properties, x, y);
    }

    @Override
    protected void ensureProperties(Properties properties) {
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(Properties.NUM_INPUTS);
    }

    @Override
    public NorGate buildGate(Properties properties) {
        int numInputs = properties.getValue(Properties.NUM_INPUTS);
        return new NorGate(properties.getValue(Properties.LABEL), (int)properties.getValue(Properties.BITSIZE), numInputs, NorGatePeer.parseNegatedInputs(numInputs, properties));
    }

    @Override
    public void paintGate(GraphicsContext graphics, CircuitState circuitState) {
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = 40;
        int height = 40;
        graphics.beginPath();
        graphics.moveTo((double)x, (double)(y + height));
        graphics.arc((double)x, (double)y + (double)height * 0.5, (double)width * 0.25, (double)height * 0.5, 270.0, 180.0);
        graphics.arcTo((double)x + (double)width * 0.66, (double)y, (double)(x + width), (double)y + (double)height * 1.3, (double)width * 0.7);
        graphics.arcTo((double)x + (double)width * 0.66, (double)(y + height), (double)x, (double)(y + height), (double)width * 0.7);
        graphics.closePath();
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        graphics.fill();
        graphics.stroke();
        graphics.fillOval((double)x + (double)width * 0.8, (double)y + (double)height * 0.5 - (double)width * 0.1, (double)width * 0.2, (double)width * 0.2);
        graphics.strokeOval((double)x + (double)width * 0.8, (double)y + (double)height * 0.5 - (double)width * 0.1, (double)width * 0.2, (double)width * 0.2);
    }
}

